/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.util.Random;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.VersionUtils;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportModule;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.local.LocalTransport;

public class AssertingLocalTransport
extends LocalTransport {
    public static final String ASSERTING_TRANSPORT_MIN_VERSION_KEY = "transport.asserting.version.min";
    public static final String ASSERTING_TRANSPORT_MAX_VERSION_KEY = "transport.asserting.version.max";
    private final Random random;
    private final Version minVersion;
    private final Version maxVersion;

    @Inject
    public AssertingLocalTransport(Settings settings, ThreadPool threadPool, Version version, NamedWriteableRegistry namedWriteableRegistry) {
        super(settings, threadPool, version, namedWriteableRegistry);
        long seed = settings.getAsLong("index.tests.seed", Long.valueOf(0L));
        this.random = new Random(seed);
        this.minVersion = settings.getAsVersion(ASSERTING_TRANSPORT_MIN_VERSION_KEY, Version.V_0_18_0);
        this.maxVersion = settings.getAsVersion(ASSERTING_TRANSPORT_MAX_VERSION_KEY, Version.CURRENT);
    }

    protected void handleParsedResponse(TransportResponse response, TransportResponseHandler handler) {
        ElasticsearchAssertions.assertVersionSerializable(VersionUtils.randomVersionBetween(this.random, this.minVersion, this.maxVersion), (Streamable)response);
        super.handleParsedResponse(response, handler);
    }

    public void sendRequest(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
        ElasticsearchAssertions.assertVersionSerializable(VersionUtils.randomVersionBetween(this.random, this.minVersion, this.maxVersion), (Streamable)request);
        super.sendRequest(node, requestId, action, request, options);
    }

    public static class TestPlugin
    extends Plugin {
        public String name() {
            return "asserting-local-transport";
        }

        public String description() {
            return "an asserting transport for testing";
        }

        public void onModule(TransportModule transportModule) {
            transportModule.addTransport("mock", AssertingLocalTransport.class);
        }

        public Settings additionalSettings() {
            return Settings.builder().put("transport.type", "mock").build();
        }
    }
}

