/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportServiceAdapter;

public class CapturingTransport
implements Transport {
    private TransportServiceAdapter adapter;
    private BlockingQueue<CapturedRequest> capturedRequests = ConcurrentCollections.newBlockingQueue();

    public CapturedRequest[] capturedRequests() {
        return this.capturedRequests.toArray(new CapturedRequest[0]);
    }

    public Map<String, List<CapturedRequest>> capturedRequestsByTargetNode() {
        HashMap<String, List<CapturedRequest>> map = new HashMap<String, List<CapturedRequest>>();
        for (CapturedRequest request : this.capturedRequests) {
            ArrayList<CapturedRequest> nodeList = (ArrayList<CapturedRequest>)map.get(request.node.id());
            if (nodeList == null) {
                nodeList = new ArrayList<CapturedRequest>();
                map.put(request.node.id(), nodeList);
            }
            nodeList.add(request);
        }
        return map;
    }

    public void clear() {
        this.capturedRequests.clear();
    }

    public void handleResponse(long requestId, TransportResponse response) {
        this.adapter.onResponseReceived(requestId).handleResponse(response);
    }

    public void handleResponse(long requestId, Throwable t) {
        this.adapter.onResponseReceived(requestId).handleException((TransportException)new RemoteTransportException("remote failure", t));
    }

    public void sendRequest(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
        this.capturedRequests.add(new CapturedRequest(node, requestId, action, request));
    }

    public void transportServiceAdapter(TransportServiceAdapter adapter) {
        this.adapter = adapter;
    }

    public BoundTransportAddress boundAddress() {
        return null;
    }

    public Map<String, BoundTransportAddress> profileBoundAddresses() {
        return null;
    }

    public TransportAddress[] addressesFromString(String address, int perAddressLimit) throws Exception {
        return new TransportAddress[0];
    }

    public boolean addressSupported(Class<? extends TransportAddress> address) {
        return false;
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return true;
    }

    public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
    }

    public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
    }

    public void disconnectFromNode(DiscoveryNode node) {
    }

    public long serverOpen() {
        return 0L;
    }

    public Lifecycle.State lifecycleState() {
        return null;
    }

    public void addLifecycleListener(LifecycleListener listener) {
    }

    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public Transport start() {
        return null;
    }

    public Transport stop() {
        return null;
    }

    public void close() {
    }

    public List<String> getLocalAddresses() {
        return Collections.EMPTY_LIST;
    }

    public static class CapturedRequest {
        public final DiscoveryNode node;
        public final long requestId;
        public final String action;
        public final TransportRequest request;

        public CapturedRequest(DiscoveryNode node, long requestId, String action, TransportRequest request) {
            this.node = node;
            this.requestId = requestId;
            this.action = action;
            this.request = request;
        }
    }
}

