/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.test.tasks.MockTaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportModule;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.local.LocalTransport;
import org.elasticsearch.transport.netty.NettyTransport;

public class MockTransportService
extends TransportService {
    private final Transport original;
    List<Tracer> activeTracers = new CopyOnWriteArrayList<Tracer>();

    public static MockTransportService local(Settings settings, Version version, ThreadPool threadPool) {
        NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry();
        LocalTransport transport = new LocalTransport(settings, threadPool, version, namedWriteableRegistry);
        return new MockTransportService(settings, (Transport)transport, threadPool);
    }

    public static MockTransportService nettyFromThreadPool(Settings settings, Version version, ThreadPool threadPool) {
        NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry();
        NettyTransport transport = new NettyTransport(settings, threadPool, new NetworkService(settings), BigArrays.NON_RECYCLING_INSTANCE, version, namedWriteableRegistry);
        return new MockTransportService(Settings.EMPTY, (Transport)transport, threadPool);
    }

    @Inject
    public MockTransportService(Settings settings, Transport transport, ThreadPool threadPool) {
        super(settings, (Transport)new LookupTestTransport(transport), threadPool);
        this.original = transport;
    }

    public static TransportAddress[] extractTransportAddresses(TransportService transportService) {
        HashSet<TransportAddress> transportAddresses = new HashSet<TransportAddress>();
        BoundTransportAddress boundTransportAddress = transportService.boundAddress();
        transportAddresses.addAll(Arrays.asList(boundTransportAddress.boundAddresses()));
        transportAddresses.add(boundTransportAddress.publishAddress());
        return transportAddresses.toArray(new TransportAddress[transportAddresses.size()]);
    }

    protected TaskManager createTaskManager() {
        if (this.settings.getAsBoolean("tests.mock.taskmanager.enabled", Boolean.valueOf(false)).booleanValue()) {
            return new MockTaskManager(this.settings);
        }
        return super.createTaskManager();
    }

    public void clearAllRules() {
        this.transport().transports.clear();
    }

    public void clearRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.clearRule(transportAddress);
        }
    }

    public void clearRule(TransportAddress transportAddress) {
        this.transport().transports.remove(transportAddress);
    }

    public Transport original() {
        return this.original;
    }

    public void addFailToSendNoConnectRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addFailToSendNoConnectRule(transportAddress);
        }
    }

    public void addFailToSendNoConnectRule(TransportAddress transportAddress) {
        this.addDelegate(transportAddress, new DelegateTransport(this.original){

            @Override
            public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
                throw new ConnectTransportException(node, "DISCONNECT: simulated");
            }

            @Override
            public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
                throw new ConnectTransportException(node, "DISCONNECT: simulated");
            }

            @Override
            public void sendRequest(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
                throw new ConnectTransportException(node, "DISCONNECT: simulated");
            }
        });
    }

    public void addFailToSendNoConnectRule(TransportService transportService, String ... blockedActions) {
        this.addFailToSendNoConnectRule(transportService, new HashSet<String>(Arrays.asList(blockedActions)));
    }

    public void addFailToSendNoConnectRule(TransportAddress transportAddress, String ... blockedActions) {
        this.addFailToSendNoConnectRule(transportAddress, new HashSet<String>(Arrays.asList(blockedActions)));
    }

    public void addFailToSendNoConnectRule(TransportService transportService, Set<String> blockedActions) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addFailToSendNoConnectRule(transportAddress, blockedActions);
        }
    }

    public void addFailToSendNoConnectRule(TransportAddress transportAddress, final Set<String> blockedActions) {
        this.addDelegate(transportAddress, new DelegateTransport(this.original){

            @Override
            public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
                MockTransportService.this.original.connectToNode(node);
            }

            @Override
            public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
                MockTransportService.this.original.connectToNodeLight(node);
            }

            @Override
            public void sendRequest(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
                if (blockedActions.contains(action)) {
                    MockTransportService.this.logger.info("--> preventing {} request", new Object[]{action});
                    throw new ConnectTransportException(node, "DISCONNECT: prevented " + action + " request");
                }
                MockTransportService.this.original.sendRequest(node, requestId, action, request, options);
            }
        });
    }

    public void addUnresponsiveRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addUnresponsiveRule(transportAddress);
        }
    }

    public void addUnresponsiveRule(TransportAddress transportAddress) {
        this.addDelegate(transportAddress, new DelegateTransport(this.original){

            @Override
            public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
                throw new ConnectTransportException(node, "UNRESPONSIVE: simulated");
            }

            @Override
            public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
                throw new ConnectTransportException(node, "UNRESPONSIVE: simulated");
            }

            @Override
            public void sendRequest(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            }
        });
    }

    public void addUnresponsiveRule(TransportService transportService, TimeValue duration) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addUnresponsiveRule(transportAddress, duration);
        }
    }

    public void addUnresponsiveRule(TransportAddress transportAddress, final TimeValue duration) {
        final long startTime = System.currentTimeMillis();
        this.addDelegate(transportAddress, new DelegateTransport(this.original){

            TimeValue getDelay() {
                return new TimeValue(duration.millis() - (System.currentTimeMillis() - startTime));
            }

            @Override
            public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
                TimeValue delay = this.getDelay();
                if (delay.millis() <= 0L) {
                    MockTransportService.this.original.connectToNode(node);
                    return;
                }
                TimeValue connectingTimeout = NetworkService.TcpSettings.TCP_DEFAULT_CONNECT_TIMEOUT;
                try {
                    if (delay.millis() >= connectingTimeout.millis()) {
                        Thread.sleep(connectingTimeout.millis());
                        throw new ConnectTransportException(node, "UNRESPONSIVE: simulated");
                    }
                    Thread.sleep(delay.millis());
                    MockTransportService.this.original.connectToNode(node);
                }
                catch (InterruptedException e) {
                    throw new ConnectTransportException(node, "UNRESPONSIVE: interrupted while sleeping", (Throwable)e);
                }
            }

            @Override
            public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
                TimeValue delay = this.getDelay();
                if (delay.millis() <= 0L) {
                    MockTransportService.this.original.connectToNodeLight(node);
                    return;
                }
                TimeValue connectingTimeout = NetworkService.TcpSettings.TCP_DEFAULT_CONNECT_TIMEOUT;
                try {
                    if (delay.millis() >= connectingTimeout.millis()) {
                        Thread.sleep(connectingTimeout.millis());
                        throw new ConnectTransportException(node, "UNRESPONSIVE: simulated");
                    }
                    Thread.sleep(delay.millis());
                    MockTransportService.this.original.connectToNodeLight(node);
                }
                catch (InterruptedException e) {
                    throw new ConnectTransportException(node, "UNRESPONSIVE: interrupted while sleeping", (Throwable)e);
                }
            }

            @Override
            public void sendRequest(final DiscoveryNode node, final long requestId, final String action, TransportRequest request, final TransportRequestOptions options) throws IOException, TransportException {
                TimeValue delay = this.getDelay();
                if (delay.millis() <= 0L) {
                    MockTransportService.this.original.sendRequest(node, requestId, action, request, options);
                    return;
                }
                RequestHandlerRegistry reg = MockTransportService.this.getRequestHandler(action);
                BytesStreamOutput bStream = new BytesStreamOutput();
                request.writeTo((StreamOutput)bStream);
                final TransportRequest clonedRequest = reg.newRequest();
                clonedRequest.readFrom(StreamInput.wrap((BytesReference)bStream.bytes()));
                MockTransportService.this.threadPool.schedule(delay, "generic", (Runnable)new AbstractRunnable(){

                    public void onFailure(Throwable e) {
                        MockTransportService.this.logger.debug("failed to send delayed request", e, new Object[0]);
                    }

                    protected void doRun() throws IOException {
                        MockTransportService.this.original.sendRequest(node, requestId, action, clonedRequest, options);
                    }
                });
            }
        });
    }

    public boolean addDelegate(TransportService transportService, DelegateTransport transport) {
        boolean noRegistered = true;
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            noRegistered &= this.addDelegate(transportAddress, transport);
        }
        return noRegistered;
    }

    public boolean addDelegate(TransportAddress transportAddress, DelegateTransport transport) {
        return this.transport().transports.put(transportAddress, transport) == null;
    }

    private LookupTestTransport transport() {
        return (LookupTestTransport)this.transport;
    }

    public void addTracer(Tracer tracer) {
        this.activeTracers.add(tracer);
    }

    public boolean removeTracer(Tracer tracer) {
        return this.activeTracers.remove(tracer);
    }

    public void clearTracers() {
        this.activeTracers.clear();
    }

    protected TransportService.Adapter createAdapter() {
        return new MockAdapter();
    }

    class MockAdapter
    extends TransportService.Adapter {
        MockAdapter() {
            super((TransportService)MockTransportService.this);
        }

        protected boolean traceEnabled() {
            return super.traceEnabled() || !MockTransportService.this.activeTracers.isEmpty();
        }

        protected void traceReceivedRequest(long requestId, String action) {
            super.traceReceivedRequest(requestId, action);
            for (Tracer tracer : MockTransportService.this.activeTracers) {
                tracer.receivedRequest(requestId, action);
            }
        }

        protected void traceResponseSent(long requestId, String action) {
            super.traceResponseSent(requestId, action);
            for (Tracer tracer : MockTransportService.this.activeTracers) {
                tracer.responseSent(requestId, action);
            }
        }

        protected void traceResponseSent(long requestId, String action, Throwable t) {
            super.traceResponseSent(requestId, action, t);
            for (Tracer tracer : MockTransportService.this.activeTracers) {
                tracer.responseSent(requestId, action, t);
            }
        }

        protected void traceReceivedResponse(long requestId, DiscoveryNode sourceNode, String action) {
            super.traceReceivedResponse(requestId, sourceNode, action);
            for (Tracer tracer : MockTransportService.this.activeTracers) {
                tracer.receivedResponse(requestId, sourceNode, action);
            }
        }

        protected void traceRequestSent(DiscoveryNode node, long requestId, String action, TransportRequestOptions options) {
            super.traceRequestSent(node, requestId, action, options);
            for (Tracer tracer : MockTransportService.this.activeTracers) {
                tracer.requestSent(node, requestId, action, options);
            }
        }
    }

    public static class Tracer {
        public void receivedRequest(long requestId, String action) {
        }

        public void responseSent(long requestId, String action) {
        }

        public void responseSent(long requestId, String action, Throwable t) {
        }

        public void receivedResponse(long requestId, DiscoveryNode sourceNode, String action) {
        }

        public void requestSent(DiscoveryNode node, long requestId, String action, TransportRequestOptions options) {
        }
    }

    public static class DelegateTransport
    implements Transport {
        protected final Transport transport;

        public DelegateTransport(Transport transport) {
            this.transport = transport;
        }

        public void transportServiceAdapter(TransportServiceAdapter service) {
            this.transport.transportServiceAdapter(service);
        }

        public BoundTransportAddress boundAddress() {
            return this.transport.boundAddress();
        }

        public TransportAddress[] addressesFromString(String address, int perAddressLimit) throws Exception {
            return this.transport.addressesFromString(address, perAddressLimit);
        }

        public boolean addressSupported(Class<? extends TransportAddress> address) {
            return this.transport.addressSupported(address);
        }

        public boolean nodeConnected(DiscoveryNode node) {
            return this.transport.nodeConnected(node);
        }

        public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
            this.transport.connectToNode(node);
        }

        public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
            this.transport.connectToNodeLight(node);
        }

        public void disconnectFromNode(DiscoveryNode node) {
            this.transport.disconnectFromNode(node);
        }

        public void sendRequest(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            this.transport.sendRequest(node, requestId, action, request, options);
        }

        public long serverOpen() {
            return this.transport.serverOpen();
        }

        public List<String> getLocalAddresses() {
            return this.transport.getLocalAddresses();
        }

        public Lifecycle.State lifecycleState() {
            return this.transport.lifecycleState();
        }

        public void addLifecycleListener(LifecycleListener listener) {
            this.transport.addLifecycleListener(listener);
        }

        public void removeLifecycleListener(LifecycleListener listener) {
            this.transport.removeLifecycleListener(listener);
        }

        public Transport start() {
            this.transport.start();
            return this;
        }

        public Transport stop() {
            this.transport.stop();
            return this;
        }

        public void close() {
            this.transport.close();
        }

        public Map<String, BoundTransportAddress> profileBoundAddresses() {
            return this.transport.profileBoundAddresses();
        }
    }

    private static class LookupTestTransport
    extends DelegateTransport {
        final ConcurrentMap<TransportAddress, Transport> transports = ConcurrentCollections.newConcurrentMap();

        LookupTestTransport(Transport transport) {
            super(transport);
        }

        private Transport getTransport(DiscoveryNode node) {
            Transport transport = (Transport)this.transports.get(node.getAddress());
            if (transport != null) {
                return transport;
            }
            return this.transport;
        }

        @Override
        public boolean nodeConnected(DiscoveryNode node) {
            return this.getTransport(node).nodeConnected(node);
        }

        @Override
        public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
            this.getTransport(node).connectToNode(node);
        }

        @Override
        public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
            this.getTransport(node).connectToNodeLight(node);
        }

        @Override
        public void disconnectFromNode(DiscoveryNode node) {
            this.getTransport(node).disconnectFromNode(node);
        }

        @Override
        public void sendRequest(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            this.getTransport(node).sendRequest(node, requestId, action, request, options);
        }
    }

    public static class TestPlugin
    extends Plugin {
        public String name() {
            return "mock-transport-service";
        }

        public String description() {
            return "a mock transport service for testing";
        }

        public void onModule(TransportModule transportModule) {
            transportModule.addTransportService("mock", MockTransportService.class);
        }

        public Settings additionalSettings() {
            return Settings.builder().put("transport.service.type", "mock").build();
        }
    }
}

