/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.suggest;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.search.suggest.SuggestBuilder;

public final class SuggestRequest
extends BroadcastRequest<SuggestRequest> {
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private BytesReference suggestSource;

    public SuggestRequest() {
    }

    public SuggestRequest(String ... indices) {
        super(indices);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        return validationException;
    }

    public BytesReference suggest() {
        return this.suggestSource;
    }

    public SuggestRequest suggest(BytesReference suggestSource) {
        this.suggestSource = suggestSource;
        return this;
    }

    public SuggestRequest suggest(SuggestBuilder suggestBuilder) {
        return this.suggest(suggestBuilder.buildAsBytes(Requests.CONTENT_TYPE));
    }

    public SuggestRequest suggest(SuggestBuilder.SuggestionBuilder suggestionBuilder) {
        return this.suggest(suggestionBuilder.buildAsBytes(Requests.CONTENT_TYPE));
    }

    public SuggestRequest suggest(String source) {
        return this.suggest(new BytesArray(source));
    }

    public String routing() {
        return this.routing;
    }

    public SuggestRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public SuggestRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public SuggestRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.suggest(in.readBytesReference());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeBytesReference(this.suggestSource);
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.suggestSource, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "[" + Arrays.toString(this.indices) + "], suggestSource[" + sSource + "]";
    }
}

