/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.file.Path;
import org.apache.lucene.util.Constants;
import org.elasticsearch.bootstrap.ConsoleCtrlHandler;
import org.elasticsearch.bootstrap.JNACLibrary;
import org.elasticsearch.bootstrap.JNAKernel32Library;
import org.elasticsearch.bootstrap.Seccomp;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.monitor.jvm.JvmInfo;

class JNANatives {
    private static final ESLogger logger = Loggers.getLogger(JNANatives.class);
    static boolean LOCAL_MLOCKALL = false;
    static boolean LOCAL_SECCOMP = false;
    static boolean LOCAL_SECCOMP_ALL = false;

    private JNANatives() {
    }

    static void tryMlockall() {
        int errno = Integer.MIN_VALUE;
        String errMsg = null;
        boolean rlimitSuccess = false;
        long softLimit = 0L;
        long hardLimit = 0L;
        try {
            int result = JNACLibrary.mlockall(1);
            if (result == 0) {
                LOCAL_MLOCKALL = true;
                return;
            }
            errno = Native.getLastError();
            errMsg = JNACLibrary.strerror(errno);
            if (Constants.LINUX || Constants.MAC_OS_X) {
                JNACLibrary.Rlimit rlimit = new JNACLibrary.Rlimit();
                if (JNACLibrary.getrlimit(JNACLibrary.RLIMIT_MEMLOCK, rlimit) == 0) {
                    rlimitSuccess = true;
                    softLimit = rlimit.rlim_cur.longValue();
                    hardLimit = rlimit.rlim_max.longValue();
                } else {
                    logger.warn("Unable to retrieve resource limits: " + JNACLibrary.strerror(Native.getLastError()), new Object[0]);
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            return;
        }
        logger.warn("Unable to lock JVM Memory: error=" + errno + ",reason=" + errMsg, new Object[0]);
        logger.warn("This can result in part of the JVM being swapped out.", new Object[0]);
        if (errno == 12) {
            if (rlimitSuccess) {
                logger.warn("Increase RLIMIT_MEMLOCK, soft limit: " + JNANatives.rlimitToString(softLimit) + ", hard limit: " + JNANatives.rlimitToString(hardLimit), new Object[0]);
                if (Constants.LINUX) {
                    String user = System.getProperty("user.name");
                    logger.warn("These can be adjusted by modifying /etc/security/limits.conf, for example: \n\t# allow user '" + user + "' mlockall\n\t" + user + " soft memlock unlimited\n\t" + user + " hard memlock unlimited", new Object[0]);
                    logger.warn("If you are logged in interactively, you will have to re-login for the new limits to take effect.", new Object[0]);
                }
            } else {
                logger.warn("Increase RLIMIT_MEMLOCK (ulimit).", new Object[0]);
            }
        }
    }

    static String rlimitToString(long value) {
        assert (Constants.LINUX || Constants.MAC_OS_X);
        if (value == JNACLibrary.RLIM_INFINITY) {
            return "unlimited";
        }
        return Long.toString(value);
    }

    static boolean definitelyRunningAsRoot() {
        if (Constants.WINDOWS) {
            return false;
        }
        try {
            return JNACLibrary.geteuid() == 0;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void tryVirtualLock() {
        JNAKernel32Library kernel = JNAKernel32Library.getInstance();
        Pointer process = null;
        try {
            process = kernel.GetCurrentProcess();
            JNAKernel32Library.SizeT size = new JNAKernel32Library.SizeT(JvmInfo.jvmInfo().getMem().getHeapInit().getBytes() + 0x100000L);
            if (!kernel.SetProcessWorkingSetSize(process, size, size)) {
                logger.warn("Unable to lock JVM memory. Failed to set working set size. Error code " + Native.getLastError(), new Object[0]);
            } else {
                JNAKernel32Library.MemoryBasicInformation memInfo = new JNAKernel32Library.MemoryBasicInformation();
                long address = 0L;
                while (kernel.VirtualQueryEx(process, new Pointer(address), memInfo, memInfo.size()) != 0) {
                    boolean lockable;
                    boolean bl = lockable = memInfo.State.longValue() == 4096L && (memInfo.Protect.longValue() & 1L) != 1L && (memInfo.Protect.longValue() & 0x100L) != 256L;
                    if (lockable) {
                        kernel.VirtualLock(memInfo.BaseAddress, new JNAKernel32Library.SizeT(memInfo.RegionSize.longValue()));
                    }
                    address += memInfo.RegionSize.longValue();
                }
                LOCAL_MLOCKALL = true;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        finally {
            if (process != null) {
                kernel.CloseHandle(process);
            }
        }
    }

    static void addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        if (Constants.WINDOWS) {
            try {
                boolean result = JNAKernel32Library.getInstance().addConsoleCtrlHandler(handler);
                if (result) {
                    logger.debug("console ctrl handler correctly set", new Object[0]);
                } else {
                    logger.warn("unknown error " + Native.getLastError() + " when adding console ctrl handler:", new Object[0]);
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
    }

    static void trySeccomp(Path tmpFile) {
        try {
            int ret = Seccomp.init(tmpFile);
            LOCAL_SECCOMP = true;
            if (ret == 1) {
                LOCAL_SECCOMP_ALL = true;
            }
        }
        catch (Throwable t) {
            if (logger.isDebugEnabled()) {
                logger.debug("unable to install syscall filter", t, new Object[0]);
            }
            logger.warn("unable to install syscall filter: " + t.getMessage(), new Object[0]);
        }
    }
}

