/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.netty.ReleaseChannelFutureListener;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.netty.NettyHttpRequest;
import org.elasticsearch.http.netty.NettyHttpServerTransport;
import org.elasticsearch.http.netty.cors.CorsHandler;
import org.elasticsearch.http.netty.pipelining.OrderedDownstreamChannelEvent;
import org.elasticsearch.http.netty.pipelining.OrderedUpstreamMessageEvent;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class NettyHttpChannel
extends HttpChannel {
    private final NettyHttpServerTransport transport;
    private final Channel channel;
    private final HttpRequest nettyRequest;
    private OrderedUpstreamMessageEvent orderedUpstreamMessageEvent = null;
    private static final HttpResponseStatus TOO_MANY_REQUESTS = new HttpResponseStatus(429, "Too Many Requests");

    public NettyHttpChannel(NettyHttpServerTransport transport, NettyHttpRequest request, boolean detailedErrorsEnabled) {
        super(request, detailedErrorsEnabled);
        this.transport = transport;
        this.channel = request.getChannel();
        this.nettyRequest = request.request();
    }

    public NettyHttpChannel(NettyHttpServerTransport transport, NettyHttpRequest request, OrderedUpstreamMessageEvent orderedUpstreamMessageEvent, boolean detailedErrorsEnabled) {
        this(transport, request, detailedErrorsEnabled);
        this.orderedUpstreamMessageEvent = orderedUpstreamMessageEvent;
    }

    @Override
    public BytesStreamOutput newBytesOutput() {
        return new ReleasableBytesStreamOutput(this.transport.bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(RestResponse response) {
        Map<String, List<String>> customHeaders;
        HttpResponse resp = this.newResponse();
        resp.setStatus(this.getStatus(response.status()));
        CorsHandler.setCorsResponseHeaders(this.nettyRequest, resp, this.transport.getCorsConfig());
        String opaque = this.nettyRequest.headers().get("X-Opaque-Id");
        if (opaque != null) {
            resp.headers().add("X-Opaque-Id", (Object)opaque);
        }
        if ((customHeaders = response.getHeaders()) != null) {
            for (Map.Entry<String, List<String>> headerEntry : customHeaders.entrySet()) {
                for (String headerValue : headerEntry.getValue()) {
                    resp.headers().add(headerEntry.getKey(), (Object)headerValue);
                }
            }
        }
        BytesReference content = response.content();
        boolean addedReleaseListener = false;
        try {
            ChannelFuture future;
            CookieDecoder cookieDecoder;
            Set cookies;
            String cookieString;
            ChannelBuffer buffer = content.toChannelBuffer();
            resp.setContent(buffer);
            if (!resp.headers().contains("Content-Type")) {
                resp.headers().add("Content-Type", (Object)response.contentType());
            }
            if (!resp.headers().contains("Content-Length")) {
                resp.headers().add("Content-Length", (Object)String.valueOf(buffer.readableBytes()));
            }
            if (this.transport.resetCookies && (cookieString = this.nettyRequest.headers().get("Cookie")) != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
                CookieEncoder cookieEncoder = new CookieEncoder(true);
                for (Cookie cookie : cookies) {
                    cookieEncoder.addCookie(cookie);
                }
                resp.headers().add("Set-Cookie", (Object)cookieEncoder.encode());
            }
            if (this.orderedUpstreamMessageEvent != null) {
                OrderedDownstreamChannelEvent downstreamChannelEvent = new OrderedDownstreamChannelEvent(this.orderedUpstreamMessageEvent, 0, true, resp);
                future = downstreamChannelEvent.getFuture();
                this.channel.getPipeline().sendDownstream((ChannelEvent)downstreamChannelEvent);
            } else {
                future = this.channel.write((Object)resp);
            }
            if (content instanceof Releasable) {
                future.addListener((ChannelFutureListener)new ReleaseChannelFutureListener((Releasable)((Object)content)));
                addedReleaseListener = true;
            }
            if (this.isCloseConnection()) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
        finally {
            if (!addedReleaseListener && content instanceof Releasable) {
                ((Releasable)((Object)content)).close();
            }
        }
    }

    private boolean isHttp10() {
        return this.nettyRequest.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0);
    }

    private boolean isCloseConnection() {
        boolean http10 = this.isHttp10();
        return "close".equalsIgnoreCase(this.nettyRequest.headers().get("Connection")) || http10 && !"keep-alive".equalsIgnoreCase(this.nettyRequest.headers().get("Connection"));
    }

    private HttpResponse newResponse() {
        DefaultHttpResponse resp;
        boolean http10 = this.isHttp10();
        boolean close = this.isCloseConnection();
        HttpResponseStatus status = HttpResponseStatus.OK;
        if (http10) {
            resp = new DefaultHttpResponse(HttpVersion.HTTP_1_0, status);
            if (!close) {
                resp.headers().add("Connection", (Object)"Keep-Alive");
            }
        } else {
            resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        }
        return resp;
    }

    private HttpResponseStatus getStatus(RestStatus status) {
        switch (status) {
            case CONTINUE: {
                return HttpResponseStatus.CONTINUE;
            }
            case SWITCHING_PROTOCOLS: {
                return HttpResponseStatus.SWITCHING_PROTOCOLS;
            }
            case OK: {
                return HttpResponseStatus.OK;
            }
            case CREATED: {
                return HttpResponseStatus.CREATED;
            }
            case ACCEPTED: {
                return HttpResponseStatus.ACCEPTED;
            }
            case NON_AUTHORITATIVE_INFORMATION: {
                return HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION;
            }
            case NO_CONTENT: {
                return HttpResponseStatus.NO_CONTENT;
            }
            case RESET_CONTENT: {
                return HttpResponseStatus.RESET_CONTENT;
            }
            case PARTIAL_CONTENT: {
                return HttpResponseStatus.PARTIAL_CONTENT;
            }
            case MULTI_STATUS: {
                return HttpResponseStatus.INTERNAL_SERVER_ERROR;
            }
            case MULTIPLE_CHOICES: {
                return HttpResponseStatus.MULTIPLE_CHOICES;
            }
            case MOVED_PERMANENTLY: {
                return HttpResponseStatus.MOVED_PERMANENTLY;
            }
            case FOUND: {
                return HttpResponseStatus.FOUND;
            }
            case SEE_OTHER: {
                return HttpResponseStatus.SEE_OTHER;
            }
            case NOT_MODIFIED: {
                return HttpResponseStatus.NOT_MODIFIED;
            }
            case USE_PROXY: {
                return HttpResponseStatus.USE_PROXY;
            }
            case TEMPORARY_REDIRECT: {
                return HttpResponseStatus.TEMPORARY_REDIRECT;
            }
            case BAD_REQUEST: {
                return HttpResponseStatus.BAD_REQUEST;
            }
            case UNAUTHORIZED: {
                return HttpResponseStatus.UNAUTHORIZED;
            }
            case PAYMENT_REQUIRED: {
                return HttpResponseStatus.PAYMENT_REQUIRED;
            }
            case FORBIDDEN: {
                return HttpResponseStatus.FORBIDDEN;
            }
            case NOT_FOUND: {
                return HttpResponseStatus.NOT_FOUND;
            }
            case METHOD_NOT_ALLOWED: {
                return HttpResponseStatus.METHOD_NOT_ALLOWED;
            }
            case NOT_ACCEPTABLE: {
                return HttpResponseStatus.NOT_ACCEPTABLE;
            }
            case PROXY_AUTHENTICATION: {
                return HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED;
            }
            case REQUEST_TIMEOUT: {
                return HttpResponseStatus.REQUEST_TIMEOUT;
            }
            case CONFLICT: {
                return HttpResponseStatus.CONFLICT;
            }
            case GONE: {
                return HttpResponseStatus.GONE;
            }
            case LENGTH_REQUIRED: {
                return HttpResponseStatus.LENGTH_REQUIRED;
            }
            case PRECONDITION_FAILED: {
                return HttpResponseStatus.PRECONDITION_FAILED;
            }
            case REQUEST_ENTITY_TOO_LARGE: {
                return HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE;
            }
            case REQUEST_URI_TOO_LONG: {
                return HttpResponseStatus.REQUEST_URI_TOO_LONG;
            }
            case UNSUPPORTED_MEDIA_TYPE: {
                return HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE;
            }
            case REQUESTED_RANGE_NOT_SATISFIED: {
                return HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE;
            }
            case EXPECTATION_FAILED: {
                return HttpResponseStatus.EXPECTATION_FAILED;
            }
            case UNPROCESSABLE_ENTITY: {
                return HttpResponseStatus.BAD_REQUEST;
            }
            case LOCKED: {
                return HttpResponseStatus.BAD_REQUEST;
            }
            case FAILED_DEPENDENCY: {
                return HttpResponseStatus.BAD_REQUEST;
            }
            case TOO_MANY_REQUESTS: {
                return TOO_MANY_REQUESTS;
            }
            case INTERNAL_SERVER_ERROR: {
                return HttpResponseStatus.INTERNAL_SERVER_ERROR;
            }
            case NOT_IMPLEMENTED: {
                return HttpResponseStatus.NOT_IMPLEMENTED;
            }
            case BAD_GATEWAY: {
                return HttpResponseStatus.BAD_GATEWAY;
            }
            case SERVICE_UNAVAILABLE: {
                return HttpResponseStatus.SERVICE_UNAVAILABLE;
            }
            case GATEWAY_TIMEOUT: {
                return HttpResponseStatus.GATEWAY_TIMEOUT;
            }
            case HTTP_VERSION_NOT_SUPPORTED: {
                return HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED;
            }
        }
        return HttpResponseStatus.INTERNAL_SERVER_ERROR;
    }
}

