/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.netty.NettyUtils;
import org.elasticsearch.common.netty.OpenChannelsHandler;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServerAdapter;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.http.netty.ESHttpContentDecompressor;
import org.elasticsearch.http.netty.ESHttpResponseEncoder;
import org.elasticsearch.http.netty.HttpRequestHandler;
import org.elasticsearch.http.netty.cors.CorsConfig;
import org.elasticsearch.http.netty.cors.CorsConfigBuilder;
import org.elasticsearch.http.netty.cors.CorsHandler;
import org.elasticsearch.http.netty.pipelining.HttpPipeliningHandler;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.rest.support.RestUtils;
import org.elasticsearch.transport.BindTransportException;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.AdaptiveReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.ReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.timeout.ReadTimeoutException;

public class NettyHttpServerTransport
extends AbstractLifecycleComponent<HttpServerTransport>
implements HttpServerTransport {
    public static final String SETTING_CORS_ENABLED = "http.cors.enabled";
    public static final String SETTING_CORS_ALLOW_ORIGIN = "http.cors.allow-origin";
    public static final String SETTING_CORS_MAX_AGE = "http.cors.max-age";
    public static final String SETTING_CORS_ALLOW_METHODS = "http.cors.allow-methods";
    public static final String SETTING_CORS_ALLOW_HEADERS = "http.cors.allow-headers";
    public static final String SETTING_CORS_ALLOW_CREDENTIALS = "http.cors.allow-credentials";
    public static final String SETTING_PIPELINING = "http.pipelining";
    public static final String SETTING_PIPELINING_MAX_EVENTS = "http.pipelining.max_events";
    public static final String SETTING_HTTP_COMPRESSION = "http.compression";
    public static final String SETTING_HTTP_COMPRESSION_LEVEL = "http.compression_level";
    public static final String SETTING_HTTP_DETAILED_ERRORS_ENABLED = "http.detailed_errors.enabled";
    public static final boolean DEFAULT_SETTING_PIPELINING = true;
    public static final int DEFAULT_SETTING_PIPELINING_MAX_EVENTS = 10000;
    public static final String DEFAULT_PORT_RANGE = "9200-9300";
    private static final String[] DEFAULT_CORS_METHODS;
    private static final String[] DEFAULT_CORS_HEADERS;
    private static final int DEFAULT_CORS_MAX_AGE = 1728000;
    protected final NetworkService networkService;
    protected final BigArrays bigArrays;
    protected final ByteSizeValue maxContentLength;
    protected final ByteSizeValue maxInitialLineLength;
    protected final ByteSizeValue maxHeaderSize;
    protected final ByteSizeValue maxChunkSize;
    protected final int workerCount;
    protected final boolean blockingServer;
    protected final boolean pipelining;
    protected final int pipeliningMaxEvents;
    protected final boolean compression;
    protected final int compressionLevel;
    protected final boolean resetCookies;
    protected final String port;
    protected final String[] bindHosts;
    protected final String[] publishHosts;
    protected final boolean detailedErrorsEnabled;
    protected final String tcpNoDelay;
    protected final String tcpKeepAlive;
    protected final boolean reuseAddress;
    protected final ByteSizeValue tcpSendBufferSize;
    protected final ByteSizeValue tcpReceiveBufferSize;
    protected final ReceiveBufferSizePredictorFactory receiveBufferSizePredictorFactory;
    protected final ByteSizeValue maxCumulationBufferCapacity;
    protected final int maxCompositeBufferComponents;
    protected volatile ServerBootstrap serverBootstrap;
    protected volatile BoundTransportAddress boundAddress;
    protected volatile List<Channel> serverChannels = new ArrayList<Channel>();
    OpenChannelsHandler serverOpenChannels;
    protected volatile HttpServerAdapter httpServerAdapter;
    private final CorsConfig corsConfig;

    @Inject
    public NettyHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays) {
        super(settings);
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        if (settings.getAsBoolean("netty.epollBugWorkaround", (Boolean)false).booleanValue()) {
            System.setProperty("org.jboss.netty.epollBugWorkaround", "true");
        }
        ByteSizeValue maxContentLength = settings.getAsBytesSize("http.netty.max_content_length", settings.getAsBytesSize("http.max_content_length", new ByteSizeValue(100L, ByteSizeUnit.MB)));
        this.maxChunkSize = settings.getAsBytesSize("http.netty.max_chunk_size", settings.getAsBytesSize("http.max_chunk_size", new ByteSizeValue(8L, ByteSizeUnit.KB)));
        this.maxHeaderSize = settings.getAsBytesSize("http.netty.max_header_size", settings.getAsBytesSize("http.max_header_size", new ByteSizeValue(8L, ByteSizeUnit.KB)));
        this.maxInitialLineLength = settings.getAsBytesSize("http.netty.max_initial_line_length", settings.getAsBytesSize("http.max_initial_line_length", new ByteSizeValue(4L, ByteSizeUnit.KB)));
        this.resetCookies = settings.getAsBoolean("http.netty.reset_cookies", settings.getAsBoolean("http.reset_cookies", (Boolean)false));
        this.maxCumulationBufferCapacity = settings.getAsBytesSize("http.netty.max_cumulation_buffer_capacity", null);
        this.maxCompositeBufferComponents = settings.getAsInt("http.netty.max_composite_buffer_components", (Integer)-1);
        this.workerCount = settings.getAsInt("http.netty.worker_count", (Integer)(EsExecutors.boundedNumberOfProcessors(settings) * 2));
        this.blockingServer = settings.getAsBoolean("http.netty.http.blocking_server", settings.getAsBoolean("network.tcp.blocking_server", settings.getAsBoolean("network.tcp.blocking", (Boolean)false)));
        this.port = settings.get("http.netty.port", settings.get("http.port", DEFAULT_PORT_RANGE));
        this.bindHosts = settings.getAsArray("http.netty.bind_host", settings.getAsArray("http.bind_host", settings.getAsArray("http.host", null)));
        this.publishHosts = settings.getAsArray("http.netty.publish_host", settings.getAsArray("http.publish_host", settings.getAsArray("http.host", null)));
        this.tcpNoDelay = settings.get("http.netty.tcp_no_delay", settings.get("network.tcp.no_delay", "true"));
        this.tcpKeepAlive = settings.get("http.netty.tcp_keep_alive", settings.get("network.tcp.keep_alive", "true"));
        this.reuseAddress = settings.getAsBoolean("http.netty.reuse_address", settings.getAsBoolean("network.tcp.reuse_address", (Boolean)NetworkUtils.defaultReuseAddress()));
        this.tcpSendBufferSize = settings.getAsBytesSize("http.netty.tcp_send_buffer_size", settings.getAsBytesSize("network.tcp.send_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_SEND_BUFFER_SIZE));
        this.tcpReceiveBufferSize = settings.getAsBytesSize("http.netty.tcp_receive_buffer_size", settings.getAsBytesSize("network.tcp.receive_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_RECEIVE_BUFFER_SIZE));
        this.detailedErrorsEnabled = settings.getAsBoolean(SETTING_HTTP_DETAILED_ERRORS_ENABLED, (Boolean)true);
        long defaultReceiverPredictor = 524288L;
        if (JvmInfo.jvmInfo().getMem().getDirectMemoryMax().bytes() > 0L) {
            long l = (long)(0.3 * (double)JvmInfo.jvmInfo().getMem().getDirectMemoryMax().bytes() / (double)this.workerCount);
            defaultReceiverPredictor = Math.min(defaultReceiverPredictor, Math.max(l, 65536L));
        }
        ByteSizeValue receivePredictorMin = settings.getAsBytesSize("http.netty.receive_predictor_min", settings.getAsBytesSize("http.netty.receive_predictor_size", new ByteSizeValue(defaultReceiverPredictor)));
        ByteSizeValue receivePredictorMax = settings.getAsBytesSize("http.netty.receive_predictor_max", settings.getAsBytesSize("http.netty.receive_predictor_size", new ByteSizeValue(defaultReceiverPredictor)));
        this.receiveBufferSizePredictorFactory = receivePredictorMax.bytes() == receivePredictorMin.bytes() ? new FixedReceiveBufferSizePredictorFactory((int)receivePredictorMax.bytes()) : new AdaptiveReceiveBufferSizePredictorFactory((int)receivePredictorMin.bytes(), (int)receivePredictorMin.bytes(), (int)receivePredictorMax.bytes());
        this.compression = settings.getAsBoolean(SETTING_HTTP_COMPRESSION, (Boolean)false);
        this.compressionLevel = settings.getAsInt(SETTING_HTTP_COMPRESSION_LEVEL, (Integer)6);
        this.pipelining = settings.getAsBoolean(SETTING_PIPELINING, (Boolean)true);
        this.pipeliningMaxEvents = settings.getAsInt(SETTING_PIPELINING_MAX_EVENTS, (Integer)10000);
        this.corsConfig = this.buildCorsConfig(settings);
        if (maxContentLength.bytes() > Integer.MAX_VALUE) {
            this.logger.warn("maxContentLength[" + maxContentLength + "] set to high value, resetting it to [100mb]", new Object[0]);
            maxContentLength = new ByteSizeValue(100L, ByteSizeUnit.MB);
        }
        this.maxContentLength = maxContentLength;
        this.logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], receive_predictor[{}->{}], pipelining[{}], pipelining_max_events[{}]", this.maxChunkSize, this.maxHeaderSize, this.maxInitialLineLength, this.maxContentLength, receivePredictorMin, receivePredictorMax, this.pipelining, this.pipeliningMaxEvents);
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public void httpServerAdapter(HttpServerAdapter httpServerAdapter) {
        this.httpServerAdapter = httpServerAdapter;
    }

    @Override
    protected void doStart() {
        this.serverOpenChannels = new OpenChannelsHandler(this.logger);
        this.serverBootstrap = this.blockingServer ? new ServerBootstrap((ChannelFactory)new OioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "http_server_boss")), (Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "http_server_worker")))) : new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "http_server_boss")), (Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "http_server_worker")), this.workerCount));
        this.serverBootstrap.setPipelineFactory(this.configureServerChannelPipelineFactory());
        if (!"default".equals(this.tcpNoDelay)) {
            this.serverBootstrap.setOption("child.tcpNoDelay", (Object)Booleans.parseBoolean(this.tcpNoDelay, null));
        }
        if (!"default".equals(this.tcpKeepAlive)) {
            this.serverBootstrap.setOption("child.keepAlive", (Object)Booleans.parseBoolean(this.tcpKeepAlive, null));
        }
        if (this.tcpSendBufferSize != null && this.tcpSendBufferSize.bytes() > 0L) {
            this.serverBootstrap.setOption("child.sendBufferSize", (Object)this.tcpSendBufferSize.bytes());
        }
        if (this.tcpReceiveBufferSize != null && this.tcpReceiveBufferSize.bytes() > 0L) {
            this.serverBootstrap.setOption("child.receiveBufferSize", (Object)this.tcpReceiveBufferSize.bytes());
        }
        this.serverBootstrap.setOption("receiveBufferSizePredictorFactory", (Object)this.receiveBufferSizePredictorFactory);
        this.serverBootstrap.setOption("child.receiveBufferSizePredictorFactory", (Object)this.receiveBufferSizePredictorFactory);
        this.serverBootstrap.setOption("reuseAddress", (Object)this.reuseAddress);
        this.serverBootstrap.setOption("child.reuseAddress", (Object)this.reuseAddress);
        this.boundAddress = this.createBoundHttpAddress();
    }

    private BoundTransportAddress createBoundHttpAddress() {
        InetAddress publishInetAddress;
        InetAddress[] hostAddresses;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(this.bindHosts);
        }
        catch (IOException e) {
            throw new BindHttpException("Failed to resolve host [" + Arrays.toString(this.bindHosts) + "]", e);
        }
        ArrayList<InetSocketTransportAddress> boundAddresses = new ArrayList<InetSocketTransportAddress>(hostAddresses.length);
        for (InetAddress address : hostAddresses) {
            boundAddresses.add(this.bindAddress(address));
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(this.publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = NettyHttpServerTransport.resolvePublishPort(this.settings, boundAddresses, publishInetAddress);
        InetSocketAddress publishAddress = new InetSocketAddress(publishInetAddress, publishPort);
        return new BoundTransportAddress(boundAddresses.toArray(new TransportAddress[boundAddresses.size()]), new InetSocketTransportAddress(publishAddress));
    }

    static int resolvePublishPort(Settings settings, List<InetSocketTransportAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = settings.getAsInt("http.netty.publish_port", settings.getAsInt("http.publish_port", (Integer)-1));
        if (publishPort < 0) {
            for (InetSocketTransportAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.address().getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            IntHashSet ports = new IntHashSet();
            for (InetSocketTransportAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = ((IntCursor)ports.iterator().next()).value;
            }
        }
        if (publishPort < 0) {
            throw new BindHttpException("Failed to auto-resolve http publish port, multiple bound addresses " + boundAddresses + " with distinct ports and none of them matched the publish address (" + publishInetAddress + "). Please specify a unique port by setting http.port or http.publish_port");
        }
        return publishPort;
    }

    private CorsConfig buildCorsConfig(Settings settings) {
        Pattern p;
        if (!settings.getAsBoolean(SETTING_CORS_ENABLED, (Boolean)false).booleanValue()) {
            return CorsConfigBuilder.forOrigins(new String[0]).disable().build();
        }
        String origin = settings.get(SETTING_CORS_ALLOW_ORIGIN);
        CorsConfigBuilder builder = Strings.isNullOrEmpty(origin) ? CorsConfigBuilder.forOrigins(new String[0]) : (origin.equals("*") ? CorsConfigBuilder.forAnyOrigin() : ((p = RestUtils.checkCorsSettingForRegex(origin)) == null ? CorsConfigBuilder.forOrigins(RestUtils.corsSettingAsArray(origin)) : CorsConfigBuilder.forPattern(p)));
        if (settings.getAsBoolean(SETTING_CORS_ALLOW_CREDENTIALS, (Boolean)false).booleanValue()) {
            builder.allowCredentials();
        }
        String[] strMethods = settings.getAsArray(SETTING_CORS_ALLOW_METHODS, DEFAULT_CORS_METHODS);
        HttpMethod[] methods = new HttpMethod[strMethods.length];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = HttpMethod.valueOf((String)strMethods[i]);
        }
        return builder.allowedRequestMethods(methods).maxAge(settings.getAsInt(SETTING_CORS_MAX_AGE, (Integer)1728000).intValue()).allowedRequestHeaders(settings.getAsArray(SETTING_CORS_ALLOW_HEADERS, DEFAULT_CORS_HEADERS)).shortCircuit().build();
    }

    private InetSocketTransportAddress bindAddress(final InetAddress hostAddress) {
        PortsRange portsRange = new PortsRange(this.port);
        final AtomicReference boundSocket = new AtomicReference();
        final AtomicReference lastException = new AtomicReference();
        boolean success = portsRange.iterate(new PortsRange.PortCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onPortNumber(int portNumber) {
                try {
                    List<Channel> list = NettyHttpServerTransport.this.serverChannels;
                    synchronized (list) {
                        Channel channel = NettyHttpServerTransport.this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(hostAddress, portNumber));
                        NettyHttpServerTransport.this.serverChannels.add(channel);
                        boundSocket.set((InetSocketAddress)channel.getLocalAddress());
                    }
                }
                catch (Exception e) {
                    lastException.set(e);
                    return false;
                }
                return true;
            }
        });
        if (!success) {
            throw new BindHttpException("Failed to bind to [" + this.port + "]", (Throwable)lastException.get());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound http to address {{}}", NetworkAddress.format((InetSocketAddress)boundSocket.get()));
        }
        return new InetSocketTransportAddress((InetSocketAddress)boundSocket.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        List<Channel> list = this.serverChannels;
        synchronized (list) {
            if (this.serverChannels != null) {
                for (Channel channel : this.serverChannels) {
                    channel.close().awaitUninterruptibly();
                }
                this.serverChannels = null;
            }
        }
        if (this.serverOpenChannels != null) {
            this.serverOpenChannels.close();
            this.serverOpenChannels = null;
        }
        if (this.serverBootstrap != null) {
            this.serverBootstrap.releaseExternalResources();
            this.serverBootstrap = null;
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public HttpInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new HttpInfo(boundTransportAddress, this.maxContentLength.bytes());
    }

    @Override
    public HttpStats stats() {
        OpenChannelsHandler channels = this.serverOpenChannels;
        return new HttpStats(channels == null ? 0L : channels.numberOfOpenChannels(), channels == null ? 0L : channels.totalChannels());
    }

    public CorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    protected void dispatchRequest(HttpRequest request, HttpChannel channel) {
        this.httpServerAdapter.dispatchRequest(request, channel);
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (e.getCause() instanceof ReadTimeoutException) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Connection timeout [{}]", ctx.getChannel().getRemoteAddress());
            }
            ctx.getChannel().close();
        } else {
            if (!this.lifecycle.started()) {
                return;
            }
            if (!NetworkExceptionHelper.isCloseConnectionException(e.getCause())) {
                this.logger.warn("Caught exception while handling client http traffic, closing connection {}", e.getCause(), ctx.getChannel());
                ctx.getChannel().close();
            } else {
                this.logger.debug("Caught exception while handling client http traffic, closing connection {}", e.getCause(), ctx.getChannel());
                ctx.getChannel().close();
            }
        }
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory() {
        return new HttpChannelPipelineFactory(this, this.detailedErrorsEnabled);
    }

    static {
        NettyUtils.setup();
        DEFAULT_CORS_METHODS = new String[]{"OPTIONS", "HEAD", "GET", "POST", "PUT", "DELETE"};
        DEFAULT_CORS_HEADERS = new String[]{"X-Requested-With", "Content-Type", "Content-Length"};
    }

    protected static class HttpChannelPipelineFactory
    implements ChannelPipelineFactory {
        protected final NettyHttpServerTransport transport;
        protected final HttpRequestHandler requestHandler;

        public HttpChannelPipelineFactory(NettyHttpServerTransport transport, boolean detailedErrorsEnabled) {
            this.transport = transport;
            this.requestHandler = new HttpRequestHandler(transport, detailedErrorsEnabled);
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("openChannels", (ChannelHandler)this.transport.serverOpenChannels);
            HttpRequestDecoder requestDecoder = new HttpRequestDecoder((int)this.transport.maxInitialLineLength.bytes(), (int)this.transport.maxHeaderSize.bytes(), (int)this.transport.maxChunkSize.bytes());
            if (this.transport.maxCumulationBufferCapacity != null) {
                if (this.transport.maxCumulationBufferCapacity.bytes() > Integer.MAX_VALUE) {
                    requestDecoder.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                } else {
                    requestDecoder.setMaxCumulationBufferCapacity((int)this.transport.maxCumulationBufferCapacity.bytes());
                }
            }
            if (this.transport.maxCompositeBufferComponents != -1) {
                requestDecoder.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            }
            pipeline.addLast("decoder", (ChannelHandler)requestDecoder);
            pipeline.addLast("decoder_compress", (ChannelHandler)new ESHttpContentDecompressor(this.transport.compression));
            HttpChunkAggregator httpChunkAggregator = new HttpChunkAggregator((int)this.transport.maxContentLength.bytes());
            if (this.transport.maxCompositeBufferComponents != -1) {
                httpChunkAggregator.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            }
            pipeline.addLast("aggregator", (ChannelHandler)httpChunkAggregator);
            pipeline.addLast("encoder", (ChannelHandler)new ESHttpResponseEncoder());
            if (this.transport.compression) {
                pipeline.addLast("encoder_compress", (ChannelHandler)new HttpContentCompressor(this.transport.compressionLevel));
            }
            if (this.transport.settings().getAsBoolean(NettyHttpServerTransport.SETTING_CORS_ENABLED, (Boolean)false).booleanValue()) {
                pipeline.addLast("cors", (ChannelHandler)new CorsHandler(this.transport.getCorsConfig()));
            }
            if (this.transport.pipelining) {
                pipeline.addLast("pipelining", (ChannelHandler)new HttpPipeliningHandler(this.transport.pipeliningMaxEvents));
            }
            pipeline.addLast("handler", (ChannelHandler)this.requestHandler);
            return pipeline;
        }
    }
}

