/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.movavg;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelParserMapper;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.internal.SearchContext;

public class MovAvgParser
implements PipelineAggregator.Parser {
    public static final ParseField MODEL = new ParseField("model", new String[0]);
    public static final ParseField WINDOW = new ParseField("window", new String[0]);
    public static final ParseField SETTINGS = new ParseField("settings", new String[0]);
    public static final ParseField PREDICT = new ParseField("predict", new String[0]);
    public static final ParseField MINIMIZE = new ParseField("minimize", new String[0]);
    private final MovAvgModelParserMapper movAvgModelParserMapper;

    @Inject
    public MovAvgParser(MovAvgModelParserMapper movAvgModelParserMapper) {
        this.movAvgModelParserMapper = movAvgModelParserMapper;
    }

    @Override
    public String type() {
        return MovAvgPipelineAggregator.TYPE.name();
    }

    @Override
    public PipelineAggregatorFactory parse(String pipelineAggregatorName, XContentParser parser, SearchContext context) throws IOException {
        MovAvgModel movAvgModel;
        XContentParser.Token token;
        String currentFieldName = null;
        String[] bucketsPaths = null;
        String format = null;
        BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;
        int window = 5;
        Map<String, Object> settings = null;
        String model = "simple";
        int predict = 0;
        Boolean minimize = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (context.parseFieldMatcher().match(currentFieldName, WINDOW)) {
                    window = parser.intValue();
                    if (window > 0) continue;
                    throw new SearchParseException(context, "[" + currentFieldName + "] value must be a positive, non-zero integer.  Value supplied was [" + predict + "] in [" + pipelineAggregatorName + "].", parser.getTokenLocation());
                }
                if (context.parseFieldMatcher().match(currentFieldName, PREDICT)) {
                    predict = parser.intValue();
                    if (predict > 0) continue;
                    throw new SearchParseException(context, "[" + currentFieldName + "] value must be a positive, non-zero integer.  Value supplied was [" + predict + "] in [" + pipelineAggregatorName + "].", parser.getTokenLocation());
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (context.parseFieldMatcher().match(currentFieldName, FORMAT)) {
                    format = parser.text();
                    continue;
                }
                if (context.parseFieldMatcher().match(currentFieldName, BUCKETS_PATH)) {
                    bucketsPaths = new String[]{parser.text()};
                    continue;
                }
                if (context.parseFieldMatcher().match(currentFieldName, GAP_POLICY)) {
                    gapPolicy = BucketHelpers.GapPolicy.parse(context, parser.text(), parser.getTokenLocation());
                    continue;
                }
                if (context.parseFieldMatcher().match(currentFieldName, MODEL)) {
                    model = parser.text();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (context.parseFieldMatcher().match(currentFieldName, BUCKETS_PATH)) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser.text();
                        paths.add(path);
                    }
                    bucketsPaths = paths.toArray(new String[paths.size()]);
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (context.parseFieldMatcher().match(currentFieldName, SETTINGS)) {
                    settings = parser.map();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if (context.parseFieldMatcher().match(currentFieldName, MINIMIZE)) {
                    minimize = parser.booleanValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + pipelineAggregatorName + "].", parser.getTokenLocation());
        }
        if (bucketsPaths == null) {
            throw new SearchParseException(context, "Missing required field [" + BUCKETS_PATH.getPreferredName() + "] for movingAvg aggregation [" + pipelineAggregatorName + "]", parser.getTokenLocation());
        }
        ValueFormatter formatter = null;
        formatter = format != null ? ValueFormat.Number.format(format).formatter() : ValueFormatter.RAW;
        MovAvgModel.AbstractModelParser modelParser = this.movAvgModelParserMapper.get(model);
        if (modelParser == null) {
            throw new SearchParseException(context, "Unknown model [" + model + "] specified.  Valid options are:" + this.movAvgModelParserMapper.getAllNames().toString(), parser.getTokenLocation());
        }
        try {
            movAvgModel = modelParser.parse(settings, pipelineAggregatorName, window, context.parseFieldMatcher());
        }
        catch (ParseException exception) {
            throw new SearchParseException(context, "Could not parse settings for model [" + model + "].", null, exception);
        }
        if (minimize == null) {
            minimize = movAvgModel.minimizeByDefault();
        } else if (minimize.booleanValue() && !movAvgModel.canBeMinimized()) {
            throw new SearchParseException(context, "The [" + model + "] model cannot be minimized.", null);
        }
        return new MovAvgPipelineAggregator.Factory(pipelineAggregatorName, bucketsPaths, formatter, gapPolicy, window, predict, movAvgModel, minimize);
    }
}

