/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.internal.SearchContext;

public class GeoPointParser {
    private final String aggName;
    private final InternalAggregation.Type aggType;
    private final SearchContext context;
    private final ParseField field;
    GeoPoint point;

    public GeoPointParser(String aggName, InternalAggregation.Type aggType, SearchContext context, ParseField field) {
        this.aggName = aggName;
        this.aggType = aggType;
        this.context = context;
        this.field = field;
    }

    public boolean token(String currentFieldName, XContentParser.Token token, XContentParser parser) throws IOException {
        if (!this.context.parseFieldMatcher().match(currentFieldName, this.field)) {
            return false;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            this.point = new GeoPoint();
            this.point.resetFromString(parser.text());
            return true;
        }
        if (token == XContentParser.Token.START_ARRAY) {
            double lat = Double.NaN;
            double lon = Double.NaN;
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (Double.isNaN(lon)) {
                    lon = parser.doubleValue();
                    continue;
                }
                if (Double.isNaN(lat)) {
                    lat = parser.doubleValue();
                    continue;
                }
                throw new SearchParseException(this.context, "malformed [" + currentFieldName + "] geo point array in [" + this.aggName + "] " + this.aggType + " aggregation. a geo point array must be of the form [lon, lat]", parser.getTokenLocation());
            }
            this.point = new GeoPoint(lat, lon);
            return true;
        }
        if (token == XContentParser.Token.START_OBJECT) {
            double lat = Double.NaN;
            double lon = Double.NaN;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.VALUE_NUMBER) continue;
                if ("lat".equals(currentFieldName)) {
                    lat = parser.doubleValue();
                    continue;
                }
                if (!"lon".equals(currentFieldName)) continue;
                lon = parser.doubleValue();
            }
            if (Double.isNaN(lat) || Double.isNaN(lon)) {
                throw new SearchParseException(this.context, "malformed [" + currentFieldName + "] geo point object. either [lat] or [lon] (or both) are missing in [" + this.aggName + "] " + this.aggType + " aggregation", parser.getTokenLocation());
            }
            this.point = new GeoPoint(lat, lon);
            return true;
        }
        return false;
    }

    public GeoPoint geoPoint() {
        return this.point;
    }
}

