/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.elasticsearch4s;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.reflect.ClassTag;

public final class JsonUtils$ {
    public static final JsonUtils$ MODULE$;

    static {
        new JsonUtils$();
    }

    public String serialize(Object doc) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        SimpleModule testModule = new SimpleModule("MyModule", Version.unknownVersion()).addSerializer(LocalDate.class, (JsonSerializer)new JsonSerializer<LocalDate>(){

            public void serialize(LocalDate value, JsonGenerator generator, SerializerProvider provider) {
                generator.writeString(value.toString("yyyy/MM/dd", Locale.ENGLISH));
            }
        }).addSerializer(DateTime.class, (JsonSerializer)new JsonSerializer<DateTime>(){

            public void serialize(DateTime value, JsonGenerator generator, SerializerProvider provider) {
                DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZoneUTC();
                generator.writeString(formatter.print((ReadableInstant)value));
            }
        });
        mapper.registerModule((Module)testModule);
        return mapper.writeValueAsString(doc);
    }

    public <T> T deserialize(String json, ClassTag<T> c) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        SimpleModule testModule = new SimpleModule("MyModule", Version.unknownVersion()).addDeserializer(LocalDate.class, (JsonDeserializer)new JsonDeserializer<LocalDate>(){

            public LocalDate deserialize(JsonParser parser, DeserializationContext context) {
                return DateTimeFormat.forPattern((String)"yyyy/MM/dd").parseLocalDate(parser.getValueAsString());
            }
        }).addDeserializer(DateTime.class, (JsonDeserializer)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonParser parser, DeserializationContext context) {
                DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZoneUTC();
                return formatter.parseDateTime(parser.getValueAsString());
            }
        });
        mapper.registerModule((Module)testModule);
        return (T)mapper.readValue(json, c.runtimeClass());
    }

    private JsonUtils$() {
        MODULE$ = this;
    }
}

