/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.action;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.Select;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import jp.co.bizreach.jdynamo.DynamoClient;
import jp.co.bizreach.jdynamo.action.DynamoBaseAction;
import jp.co.bizreach.jdynamo.action.DynamoCondExpression;
import jp.co.bizreach.jdynamo.action.DynamoQueryValue;
import jp.co.bizreach.jdynamo.action.DynamoScanResult;
import jp.co.bizreach.jdynamo.action.SafetyThreadPoolExecutor;
import jp.co.bizreach.jdynamo.action.ScanActionRunner;
import jp.co.bizreach.jdynamo.action.ScanState;
import jp.co.bizreach.jdynamo.core.DynamoThroughputAdjuster;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.data.DynamoMetaTable;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeSupport;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeWithValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoScan<T>
extends DynamoBaseAction<T> {
    private static final Logger log = LoggerFactory.getLogger(DynamoScan.class);
    private DynamoThroughputAdjuster throughputAdjuster;

    public DynamoScan(DynamoClient.DynamoClientPrivate client, DynamoMetaTable table) {
        super(client, table);
    }

    public DynamoScan<T> filter(DynamoAttributeWithValue cond) {
        this.filterValues.add(new DynamoQueryValue(cond.getAttributeDefinition(), cond));
        return this;
    }

    public DynamoScan<T> projection(DynamoAttributeSupport ... attrs) {
        List names;
        this.projectionNames = names = Arrays.stream(attrs).map(attr -> attr.getDynamoAttrName()).collect(Collectors.toList());
        return this;
    }

    public DynamoScan<T> withAdjustThroughput() {
        this.throughputAdjuster = new DynamoThroughputAdjuster(this.client.getRawDynamoClient());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamoScanResult executeSync(int threadCount, BiConsumer<List<T>, ScanContext> callbackFunction) {
        long totalScanCount;
        SafetyThreadPoolExecutor executor = new SafetyThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(threadCount));
        DynamoScanResult result = new DynamoScanResult();
        try {
            ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>();
            for (int segment = 0; segment < threadCount; ++segment) {
                ScanContext scanContext = new ScanContext();
                result.addScanContext(scanContext);
                ScanActionRunner<T> scanRunner = new ScanActionRunner<T>(this, segment, threadCount, this.table, scanContext, this.client, callbackFunction);
                futures.add(executor.submit(scanRunner));
            }
            totalScanCount = this.getTotalScanCount(callbackFunction, futures);
        }
        finally {
            executor.shutdown();
        }
        log.info("scan executor [" + this.table.getBaseTableName() + "] shutdown. total count = " + totalScanCount);
        result.setScannedCount(totalScanCount);
        return result;
    }

    private long getTotalScanCount(BiConsumer<List<T>, ScanContext> callbackFunction, List<Future<Long>> futures) {
        long totalScanCount = 0L;
        for (Future<Long> future : futures) {
            try {
                Long result = future.get();
                if (result == null) continue;
                log.info("scan result: [" + this.table.getBaseTableName() + "] count = " + result);
                totalScanCount += result.longValue();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error(e.getMessage(), (Throwable)e);
                ScanContext scanContext = new ScanContext();
                if (e.getCause() instanceof Exception) {
                    scanContext.setCauseError((Exception)e.getCause());
                }
                callbackFunction.accept(null, scanContext);
            }
        }
        return totalScanCount;
    }

    public ScanRequest makeScanRequest(int segment, int totalSegment, Map<String, AttributeValue> exclusiveStartKey) {
        ScanRequest request = this.makeScanRequest();
        request.withSegment(Integer.valueOf(segment)).withTotalSegments(Integer.valueOf(totalSegment)).withExclusiveStartKey(exclusiveStartKey);
        return request;
    }

    private ScanRequest makeScanRequest() {
        String filterExpression = this.makeFilterExpression();
        Map<String, String> expressionAttributeNames = this.makeExpressionAttributeNames();
        Map<String, AttributeValue> expressionAttributeValues = this.makeExpressionAttributeValues();
        String projectionExpression = this.makeProjectionExpression();
        Select select = projectionExpression != null ? Select.SPECIFIC_ATTRIBUTES : Select.ALL_ATTRIBUTES;
        ReturnConsumedCapacity returnConsumedCapacity = ReturnConsumedCapacity.TOTAL;
        if (log.isDebugEnabled()) {
            log.debug("new ScanRequest().\nfilterExpression = " + filterExpression + "\nexpressionAttributeNames = " + expressionAttributeNames + "\n" + "expressionAttributeValues = " + expressionAttributeValues + "\nprojectionExpression = " + projectionExpression);
        }
        return new ScanRequest().withTableName(this.client.getRealTableName(this.table)).withIndexName(this.getIndexName()).withFilterExpression(filterExpression).withExpressionAttributeNames(expressionAttributeNames).withExpressionAttributeValues(expressionAttributeValues).withSelect(select).withProjectionExpression(projectionExpression).withReturnConsumedCapacity(returnConsumedCapacity).withLimit(this.limit);
    }

    private Map<String, String> makeExpressionAttributeNames() {
        HashMap<String, String> results = new HashMap<String, String>();
        int idx = 1;
        for (DynamoCondExpression expression : this.filterValues) {
            String filterName = expression.getDynamoAttrName();
            if (results.containsValue(filterName)) continue;
            results.put("#fname" + idx, filterName);
            ++idx;
        }
        return results.isEmpty() ? null : results;
    }

    private Map<String, AttributeValue> makeExpressionAttributeValues() {
        HashMap<String, AttributeValue> results = new HashMap<String, AttributeValue>();
        int idx = 1;
        for (DynamoCondExpression expression : this.filterValues) {
            Object filterValue = expression.getTargetValue();
            DynamoMappingAttributeType mappingType = expression.getMappingType();
            if (filterValue instanceof DynamoBaseAction.RangeValue) {
                Object subFilterValue = ((DynamoBaseAction.RangeValue)filterValue).from;
                this.appendFilterValue(results, mappingType, idx, subFilterValue);
                subFilterValue = ((DynamoBaseAction.RangeValue)filterValue).to;
                this.appendFilterValue(results, mappingType, ++idx, subFilterValue);
            } else {
                this.appendFilterValue(results, mappingType, idx, filterValue);
            }
            ++idx;
        }
        return results.isEmpty() ? null : results;
    }

    public DynamoThroughputAdjuster getThroughputAdjuster() {
        return this.throughputAdjuster;
    }

    public static class ScanContext {
        private Exception causeError;
        private ScanState state;

        public boolean isError() {
            return this.causeError != null;
        }

        public Exception getCauseError() {
            return this.causeError;
        }

        public void setCauseError(Exception causeError) {
            this.causeError = causeError;
        }

        public ScanState getState() {
            return this.state;
        }

        public void setState(ScanState state) {
            this.state = state;
        }
    }
}

