/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.data;

import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import jp.co.bizreach.jdynamo.data.DynamoAttributeDefinition;
import jp.co.bizreach.jdynamo.data.DynamoMetaTable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class DynamoIndex {
    private String indexName;
    private String partitionKeyFieldName;
    private String partitionKeyDynamoName;
    private DynamoAttributeDefinition partitionAttributeDefinition;
    private String sortKeyFieldName;
    private String sortKeyDynamoName;
    private DynamoAttributeDefinition sortAttributeDefinition;

    public <T> DynamoIndex(DynamoMetaTable table, String indexName, Field partitionKeyField, Field sortKeyField) {
        this.indexName = indexName;
        if (partitionKeyField != null) {
            this.partitionKeyFieldName = partitionKeyField.getName();
            this.partitionAttributeDefinition = table.getAttributeDefinition(this.partitionKeyFieldName);
            this.partitionKeyDynamoName = partitionKeyField.getName();
        }
        if (sortKeyField != null) {
            this.sortKeyFieldName = sortKeyField.getName();
            this.sortAttributeDefinition = table.getAttributeDefinition(this.sortKeyFieldName);
            this.sortKeyDynamoName = sortKeyField.getName();
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public static DynamoIndex create(DynamoMetaTable table, String indexName, String partitionFieldName) {
        Class<?> recordClass = table.getRecordClass();
        DynamoIndex index = new DynamoIndex(table, indexName, FieldUtils.getDeclaredField(recordClass, (String)partitionFieldName, (boolean)true), null);
        table.addIndex(index);
        return index;
    }

    public static DynamoIndex create(DynamoMetaTable table, String indexName, String partitionKeyFieldName, String sortKeyFieldName) {
        Class<?> recordClass = table.getRecordClass();
        DynamoIndex index = new DynamoIndex(table, indexName, FieldUtils.getDeclaredField(recordClass, (String)partitionKeyFieldName, (boolean)true), FieldUtils.getDeclaredField(recordClass, (String)sortKeyFieldName, (boolean)true));
        table.addIndex(index);
        return index;
    }

    public List<KeySchemaElement> getKeySchema() {
        ArrayList<KeySchemaElement> results = new ArrayList<KeySchemaElement>();
        if (this.partitionKeyDynamoName != null) {
            results.add(new KeySchemaElement(this.partitionKeyDynamoName, KeyType.HASH));
        }
        if (this.sortKeyDynamoName != null) {
            results.add(new KeySchemaElement(this.sortKeyDynamoName, KeyType.RANGE));
        }
        return CollectionUtils.isEmpty(results) ? null : results;
    }

    public String getPartitionKeyFieldName() {
        return this.partitionKeyFieldName;
    }

    public String getPartitionKeyDynamoName() {
        return this.partitionKeyDynamoName;
    }

    public DynamoAttributeDefinition getPartitionAttributeDefinition() {
        return this.partitionAttributeDefinition;
    }

    public String getSortKeyFieldName() {
        return this.sortKeyFieldName;
    }

    public String getSortKeyDynamoName() {
        return this.sortKeyDynamoName;
    }

    public DynamoAttributeDefinition getSortAttributeDefinition() {
        return this.sortAttributeDefinition;
    }
}

