/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.data.attr;

import java.util.List;
import jp.co.bizreach.jdynamo.data.DynamoAttributeDefinition;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import org.apache.commons.lang3.StringUtils;

public class DynamoAttributeWithValue {
    private DynamoAttributeDefinition attributeDefinition;
    private DynamoMappingAttributeType attributeType;
    private String dynamoAttrName;
    private Object targetValue;
    private boolean valueExist;
    private String leftOperatorStr;
    private String middleOperatorStr;
    private String rightOperatorStr;

    public DynamoAttributeWithValue(DynamoAttributeDefinition attributeDefinition) {
        this.attributeDefinition = attributeDefinition;
        this.attributeType = attributeDefinition.getMappingType();
        this.dynamoAttrName = attributeDefinition.getDynamoAttrName();
    }

    public String getExpression(List<Integer> indexes) {
        StringBuilder sb = new StringBuilder();
        if (this.leftOperatorStr != null) {
            sb.append(this.leftOperatorStr);
        }
        String index = StringUtils.join(indexes, (String)"_");
        sb.append("#fname").append(index);
        if (this.middleOperatorStr != null) {
            sb.append(this.middleOperatorStr);
        }
        if (this.valueExist) {
            if (this.targetValue instanceof List) {
                this.appendListExpression(sb, index);
            } else {
                sb.append(":fvalue").append(index);
            }
        }
        if (this.rightOperatorStr != null) {
            sb.append(this.rightOperatorStr);
        }
        return sb.toString();
    }

    private void appendListExpression(StringBuilder sb, String index) {
        int size = ((List)this.targetValue).size();
        sb.append('(');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(":fvalue").append(index).append('L').append(Integer.toString(i));
        }
        sb.append(')');
    }

    public void setAttributeDefinition(DynamoAttributeDefinition attributeDefinition) {
        this.attributeDefinition = attributeDefinition;
    }

    public void setAttributeType(DynamoMappingAttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public void setDynamoAttrName(String dynamoAttrName) {
        this.dynamoAttrName = dynamoAttrName;
    }

    public void setTargetValue(Object targetValue) {
        this.targetValue = targetValue;
    }

    public void setValueExist(boolean valueExist) {
        this.valueExist = valueExist;
    }

    public void setLeftOperatorStr(String leftOperatorStr) {
        this.leftOperatorStr = leftOperatorStr;
    }

    public void setMiddleOperatorStr(String middleOperatorStr) {
        this.middleOperatorStr = middleOperatorStr;
    }

    public void setRightOperatorStr(String rightOperatorStr) {
        this.rightOperatorStr = rightOperatorStr;
    }

    public DynamoAttributeDefinition getAttributeDefinition() {
        return this.attributeDefinition;
    }

    public DynamoMappingAttributeType getAttributeType() {
        return this.attributeType;
    }

    public String getDynamoAttrName() {
        return this.dynamoAttrName;
    }

    public Object getTargetValue() {
        return this.targetValue;
    }
}

