/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.action;

import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.bizreach.jdynamo.DynamoClient;
import jp.co.bizreach.jdynamo.data.DynamoKey;
import jp.co.bizreach.jdynamo.data.DynamoMetaTable;
import jp.co.bizreach.jdynamo.data.DynamoUpdateValue;

public class DynamoUpdateChain<T> {
    private DynamoClient.DynamoClientPrivate client;
    private DynamoMetaTable<T> table;
    private DynamoKey key;
    private List<DynamoUpdateValue> values = new ArrayList<DynamoUpdateValue>();

    public DynamoUpdateChain(DynamoClient.DynamoClientPrivate client, DynamoMetaTable table, DynamoKey key) {
        this.client = client;
        this.table = table;
        this.key = key;
    }

    public DynamoUpdateChain set(DynamoUpdateValue value) {
        this.values.add(value);
        return this;
    }

    public void execute() {
        this.client.executeUpdate(this);
    }

    public T executeAndGet() {
        UpdateItemResult updateItemResult = this.client.executeUpdate(this, ReturnValue.ALL_NEW);
        Map attributes = updateItemResult.getAttributes();
        return this.client.toRecord(this.table, attributes);
    }

    public UpdateItemRequest makeUpdateItemRequest(UpdateItemRequest request) {
        request.withAttributeUpdates(this.table.createUpdateItem(this.values));
        return request;
    }

    public DynamoMetaTable<T> getTable() {
        return this.table;
    }

    public DynamoKey getKey() {
        return this.key;
    }
}

