/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.action;

import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import jp.co.bizreach.jdynamo.DynamoClient;
import jp.co.bizreach.jdynamo.action.DynamoScan;
import jp.co.bizreach.jdynamo.action.ScanState;
import jp.co.bizreach.jdynamo.core.DynamoThroughputAdjuster;
import jp.co.bizreach.jdynamo.data.DynamoMetaTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScanActionRunner<T>
implements Callable<Long> {
    private static final Logger log = LoggerFactory.getLogger(ScanActionRunner.class);
    private int segment;
    private int totalSegment;
    private DynamoScan.ScanContext scanContext;
    private DynamoMetaTable table;
    private DynamoScan<T> scanAction;
    private DynamoClient.DynamoClientPrivate client;
    private BiConsumer<List<T>, DynamoScan.ScanContext> callbackFunction;

    public ScanActionRunner(DynamoScan<T> scanAction, int segment, int totalSegment, DynamoMetaTable table, DynamoScan.ScanContext scanContext, DynamoClient.DynamoClientPrivate client, BiConsumer<List<T>, DynamoScan.ScanContext> callbackFunction) {
        this.scanAction = scanAction;
        this.segment = segment;
        this.totalSegment = totalSegment;
        this.table = table;
        this.scanContext = scanContext;
        this.client = client;
        this.callbackFunction = callbackFunction;
    }

    @Override
    public Long call() throws Exception {
        ScanResult result;
        ScanState state = new ScanState(this.segment, this.totalSegment);
        Map exclusiveStartKey = null;
        do {
            DynamoThroughputAdjuster adjuster = this.scanAction.getThroughputAdjuster();
            ScanRequest scanRequest = this.scanAction.makeScanRequest(this.segment, this.totalSegment, exclusiveStartKey);
            result = adjuster != null ? this.client.rawScan(scanRequest, adjuster) : this.client.rawScan(scanRequest);
            try {
                List records = this.client.toRecords(this.table, result.getItems());
                this.scanContext.setState(state);
                this.callbackFunction.accept(records, this.scanContext);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                this.scanContext.setCauseError(e);
            }
            state.addScannedCount(result.getScannedCount());
        } while ((exclusiveStartKey = result.getLastEvaluatedKey()) != null);
        return state.getTotalScannedCount();
    }
}

