/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.core;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.Date;
import java.util.function.Supplier;
import jp.co.bizreach.jdynamo.DynamoRuntimeException;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoThroughputAdjuster {
    private static final Logger log = LoggerFactory.getLogger(DynamoThroughputAdjuster.class);
    private AmazonDynamoDBClient dynamoClient;
    private int maxRetries = 10;
    private Long retryLimitMillisecond;
    private long retryStepMillisecond = 100L;
    private boolean jitter = true;

    public DynamoThroughputAdjuster(AmazonDynamoDBClient dynamoClient) {
        this.dynamoClient = dynamoClient;
    }

    public DynamoThroughputAdjuster(AmazonDynamoDBClient dynamoClient, long retryLimitMillisecond) {
        this.dynamoClient = dynamoClient;
        this.retryLimitMillisecond = retryLimitMillisecond;
    }

    public QueryResult query(QueryRequest queryRequest) {
        return this.execWithRetry(() -> this.dynamoClient.query(queryRequest));
    }

    public ScanResult scan(ScanRequest scanRequest) {
        return this.execWithRetry(() -> this.dynamoClient.scan(scanRequest));
    }

    public void put(PutItemRequest putItemRequest) {
        this.execWithRetry(() -> this.dynamoClient.putItem(putItemRequest));
    }

    private <T> T execWithRetry(Supplier<T> function) {
        int retries = 0;
        long startTime = new Date().getTime();
        while (true) {
            try {
                return function.get();
            }
            catch (ProvisionedThroughputExceededException e) {
                if (log.isDebugEnabled()) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                this.checkRetryLimit(retries, startTime);
                this.sleepExponential(retries);
                ++retries;
                continue;
            }
            break;
        }
    }

    private void checkRetryLimit(int retries, long startTime) {
        if (this.retryLimitMillisecond != null) {
            if (new Date().getTime() - startTime >= this.retryLimitMillisecond) {
                throw new DynamoRuntimeException("Retry has exceeded the limit " + this.retryLimitMillisecond + " millisecond.");
            }
        } else if (retries >= this.maxRetries) {
            throw new DynamoRuntimeException("Retry count has exceeded the limit " + this.maxRetries + ".");
        }
    }

    private void sleepExponential(int retries) {
        long waitTime = this.getWaitTimeExp(retries);
        if (log.isDebugEnabled()) {
            log.debug("Provisioned throughput has exceeded. Wait " + waitTime + " millisecond.");
        }
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private long getWaitTimeExp(int retryCount) {
        long waitTime = (long)Math.pow(2.0, retryCount) * this.retryStepMillisecond;
        return this.jitter ? RandomUtils.nextLong((long)this.retryStepMillisecond, (long)(waitTime + 1L)) : waitTime;
    }
}

