/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.util;

import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.co.bizreach.jdynamo.DynamoClient;
import jp.co.bizreach.jdynamo.data.DynamoMetaTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoCloudWatchClient {
    private static final Logger log = LoggerFactory.getLogger(DynamoCloudWatchClient.class);
    private DynamoClient.DynamoClientPrivate clientPrivate;
    private AmazonCloudWatchClient cloudWatchClient;

    public List<Datapoint> getRecentConsumedReadCapacityUnits(DynamoMetaTable table) {
        return this.getDynamoMetricDatapoints(table, "ConsumedReadCapacityUnits");
    }

    public List<Datapoint> getRecentConsumedWriteCapacityUnits(DynamoMetaTable table) {
        return this.getDynamoMetricDatapoints(table, "ConsumedWriteCapacityUnits");
    }

    private List<Datapoint> getDynamoMetricDatapoints(DynamoMetaTable table, String metricName) {
        AmazonCloudWatchClient client = this.cloudWatchClient;
        GetMetricStatisticsRequest statisticsRequest = new GetMetricStatisticsRequest();
        statisticsRequest.setNamespace("AWS/DynamoDB");
        statisticsRequest.setMetricName(metricName);
        statisticsRequest.setStartTime(new Date(new Date().getTime() - 86400000L));
        statisticsRequest.setEndTime(new Date());
        statisticsRequest.setPeriod(Integer.valueOf(60));
        statisticsRequest.setStatistics(Arrays.asList("Sum", "Maximum", "Minimum", "SampleCount", "Average"));
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        Dimension dimension = new Dimension().withName("Table").withValue(this.clientPrivate.getRealTableName(table));
        dimensions.add(dimension);
        statisticsRequest.setDimensions(dimensions);
        GetMetricStatisticsResult statisticsResult = client.getMetricStatistics(statisticsRequest);
        List datapoints = statisticsResult.getDatapoints();
        Stream<Datapoint> sorted = datapoints.stream().sorted(Comparator.comparing(Datapoint::getTimestamp).reversed());
        return sorted.collect(Collectors.toList());
    }

    @ConstructorProperties(value={"clientPrivate", "cloudWatchClient"})
    public DynamoCloudWatchClient(DynamoClient.DynamoClientPrivate clientPrivate, AmazonCloudWatchClient cloudWatchClient) {
        this.clientPrivate = clientPrivate;
        this.cloudWatchClient = cloudWatchClient;
    }
}

