package jp.co.bizreach.jdynamo.action;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import jp.co.bizreach.jdynamo.data.DynamoAttributeDefinition;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeWithValue;
import jp.co.bizreach.jdynamo.util.DynamoAttributeUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * Created by iwami on 2016/07/06.
 */
@Getter
@AllArgsConstructor
/* package */ class DynamoQueryValue implements DynamoCondExpression {

    private DynamoAttributeDefinition attributeDefinition;
    private Object value;

    @Override
    public String getExpressionText(List<Integer> index) {
        if (value instanceof DynamoAttributeWithValue) {
            DynamoAttributeWithValue cond = (DynamoAttributeWithValue) value;
            return cond.getExpression(index);
        } else {
            return value.toString();
        }
    }

    @Override
    public String getDynamoAttrName() {
        return attributeDefinition.getDynamoAttrName();
    }

    @Override
    public Object getTargetValue() {
        return value;
    }

    @Override
    public DynamoMappingAttributeType getMappingType() {
        return attributeDefinition.getMappingType();
    }

    @Override
    public void appendNames(List<Integer> indexes, Map<String, String> results) {
        String filterName = getDynamoAttrName();
        int idx = indexes.get(0);
        if (results.containsValue(filterName) == false) {
            results.put("#fname" + idx, filterName);
        }

    }

    @Override
    public void appendValues(List<Integer> indexes, Map<String, AttributeValue> results) {
        Object filterValue = ((DynamoAttributeWithValue) getTargetValue()).getTargetValue();
        if (filterValue instanceof List) {
            int sidx = 0;
            for (Object lvalue : (List)filterValue) {
                DynamoAttributeUtil.appendValue(results, attributeDefinition.getMappingType(),
                        ":fvalue" + StringUtils.join(indexes, "_") + "L" + sidx, lvalue);
                ++sidx;
            }

        } else if (filterValue != null) {
            DynamoAttributeUtil.appendValue(results, attributeDefinition.getMappingType(),
                    ":fvalue" + StringUtils.join(indexes, "_"), filterValue);
        }

    }
}
