package jp.co.bizreach.jdynamo.action;

import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * スキャン結果が格納されるクラスです。
 * Created by iwami on 2016/07/15.
 */
public class DynamoScanResult {

    /**
     * スキャンされたアイテム数
     */
    @Getter
    @Setter
    private Long scannedCount;

    @Setter
    private List<DynamoScan.ScanContext> contexts = new ArrayList<>();

    /**
     * スキャン時に発生した例外を返します。
     * スキャン処理は複数スレッドで動作するため、例外も複数発生する可能性があります。
     * @return
     */
    public List<Exception> getOccurExceptions() {
        return contexts.stream().map(DynamoScan.ScanContext::getCauseError).collect(Collectors.toList());
    }

    // ライブラリ内からしか使わないため、protected にしている
    protected void addScanContext(DynamoScan.ScanContext scanContext) {
        contexts.add(scanContext);
    }

}
