package jp.co.bizreach.jdynamo.action;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import jp.co.bizreach.jdynamo.DynamoClient;
import jp.co.bizreach.jdynamo.core.DynamoThroughputAdjuster;
import jp.co.bizreach.jdynamo.data.DynamoMetaTable;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;

/**
 * Created by iwami on 2016/07/01.
 */
@Slf4j
/* package */ class ScanActionRunner<T> implements Callable<Long> {

    private int segment;
    private int totalSegment;

    @Setter
    private Integer limit;

    private DynamoScan.ScanContext scanContext;

    private DynamoMetaTable table;
    private DynamoScan<T> scanAction;
    private DynamoClient.DynamoClientPrivate client;

    private BiConsumer<List<T>, DynamoScan.ScanContext> callbackFunction;

    public ScanActionRunner(DynamoScan<T> scanAction, int segment, int totalSegment, DynamoMetaTable table,
                            DynamoScan.ScanContext scanContext,
                            DynamoClient.DynamoClientPrivate client,
                            BiConsumer<List<T>, DynamoScan.ScanContext> callbackFunction) {
        this.scanAction = scanAction;
        this.segment = segment;
        this.totalSegment = totalSegment;
        this.table = table;
        this.scanContext = scanContext;
        this.client = client;
        this.callbackFunction = callbackFunction;
    }

    @Override
    public Long call() throws Exception {

        ScanState state = new ScanState(segment, totalSegment);
        Map<String, AttributeValue> exclusiveStartKey = null;
        do {

            DynamoThroughputAdjuster adjuster = scanAction.getThroughputAdjuster();

            ScanRequest scanRequest = scanAction.makeScanRequest(segment, totalSegment, exclusiveStartKey);

            ScanResult result = adjuster != null ? client.rawScan(scanRequest, adjuster) : client.rawScan(scanRequest);

            try {
                List<T> records = client.toRecords(table, result.getItems());
                scanContext.setState(state);
                callbackFunction.accept(records, scanContext);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
                scanContext.setCauseError(e);
            }

            state.addScannedCount(result.getScannedCount());
            exclusiveStartKey = result.getLastEvaluatedKey();
        } while (exclusiveStartKey != null);

        return state.getTotalScannedCount();
    }
}
