package jp.co.bizreach.jdynamo.action;

/**
 * スキャン状態を格納するための内部クラスです。
 * Created by iwami on 2016/07/01.
 */
/* package */ class ScanState {

    private Integer segment;

    private Integer totalSegment;

    private long totalScannedCount = 0L;

    public ScanState(int segment, int totalSegment) {
        this.segment = segment;
        this.totalSegment = totalSegment;
    }

    public int getSegment() {
        return segment;
    }

    public int getTotalSegment() {
        return totalSegment;
    }

    public long getTotalScannedCount() {
        return totalScannedCount;
    }

    public void addScannedCount(int scannedCount) {
        totalScannedCount += scannedCount;
    }

}
