package jp.co.bizreach.jdynamo.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Dynamo のメタテーブルクラスに付けるアノテーションです。
 * Created by iwami on 2016/06/30.
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface Table {

    /**
     * テーブルの基準名です。実際に扱われるテーブル名は TableNameResolver により若干変化します。
     * @return
     * @see jp.co.bizreach.jdynamo.util.DynamoTableNameResolver
     */
    String baseName();

}
