package jp.co.bizreach.jdynamo.core;

/**
 * Created by iwami on 2016/11/24.
 */
public class DynamoSnowFlakeIdGenerator {

    private static final int NODE_SHIFT = 10;
    private static final int SEQ_SHIFT = 12;

    private static final short MAX_NODE = 1024;
    private static final short MAX_SEQUENCE = 4096;

    private short sequence;
    private long referenceTime;

    private final int node;
    private final long epochTime;

    /**
     *
     * @param node ノード番号（0 - 1023）
     * @param epochTime
     */
    public DynamoSnowFlakeIdGenerator(int node, long epochTime) {
        if (node < 0 || node > MAX_NODE) {
            throw new IllegalArgumentException();
        }
        this.node = node;
        this.epochTime = epochTime;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    /**
     * @return
     */
    public long next() {

        long currentTime = timeGen();
        long counter;

        synchronized (this) {
            if (currentTime < referenceTime) {
                throw new IllegalStateException(String.format("Last referenceTime %s is after reference time %s", referenceTime, currentTime));
            } else if (currentTime > referenceTime) {
                this.sequence = 0;
            } else {
                if (this.sequence < MAX_SEQUENCE) {
                    this.sequence++;
                } else {
                    throw new IllegalStateException("Sequence exhausted at " + this.sequence);
                }
            }
            counter = this.sequence;
            referenceTime = currentTime;
        }

        return (currentTime - epochTime) << NODE_SHIFT << SEQ_SHIFT | node << SEQ_SHIFT | counter;
    }

}
