package jp.co.bizreach.jdynamo.data;

import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import lombok.Getter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by iwami on 2016/06/30.
 */
public class DynamoIndex {

    private String indexName;

    @Getter
    private String partitionKeyFieldName;
    @Getter
    private String partitionKeyDynamoName;
    @Getter
    private DynamoAttributeDefinition partitionAttributeDefinition;

    @Getter
    private String sortKeyFieldName;
    @Getter
    private String sortKeyDynamoName;
    @Getter
    private DynamoAttributeDefinition sortAttributeDefinition;

    public <T> DynamoIndex(DynamoMetaTable table, String indexName, Field partitionKeyField, Field sortKeyField) {
        this.indexName = indexName;
        if (partitionKeyField != null) {
            partitionKeyFieldName = partitionKeyField.getName();
            partitionAttributeDefinition = table.getAttributeDefinition(partitionKeyFieldName);
            partitionKeyDynamoName = partitionKeyField.getName();
        }
        if (sortKeyField != null) {
            sortKeyFieldName = sortKeyField.getName();
            sortAttributeDefinition = table.getAttributeDefinition(sortKeyFieldName);
            sortKeyDynamoName = sortKeyField.getName();
        }
    }

    public String getIndexName() {
        return indexName;
    }

    public static DynamoIndex create(DynamoMetaTable table, String indexName, String partitionFieldName) {
        Class recordClass = table.getRecordClass();
        DynamoIndex index = new DynamoIndex(table, indexName,
                FieldUtils.getDeclaredField(recordClass, partitionFieldName, true), null);
        table.addIndex(index);
        return index;
    }

    public static DynamoIndex create(DynamoMetaTable table, String indexName,
                                     String partitionKeyFieldName, String sortKeyFieldName) {
        Class recordClass = table.getRecordClass();
        DynamoIndex index = new DynamoIndex(table, indexName,
                FieldUtils.getDeclaredField(recordClass, partitionKeyFieldName, true),
                FieldUtils.getDeclaredField(recordClass, sortKeyFieldName, true));
        table.addIndex(index);
        return index;
    }

    public List<KeySchemaElement> getKeySchema() {
        List<KeySchemaElement> results = new ArrayList<>();
        if (partitionKeyDynamoName != null) {
            results.add(new KeySchemaElement(partitionKeyDynamoName, KeyType.HASH));
        }
        if (sortKeyDynamoName != null) {
            results.add(new KeySchemaElement(sortKeyDynamoName, KeyType.RANGE));
        }
        return CollectionUtils.isEmpty(results) ? null : results;
    }
}
