package jp.co.bizreach.jdynamo.data;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import jp.co.bizreach.jdynamo.data.mapper.DynamoBooleanMapper;
import jp.co.bizreach.jdynamo.data.mapper.DynamoCompressStringMapper;
import jp.co.bizreach.jdynamo.data.mapper.DynamoDateMapper;
import jp.co.bizreach.jdynamo.data.mapper.DynamoDateTimeMapper;
import jp.co.bizreach.jdynamo.data.mapper.DynamoDecimalMapper;
import jp.co.bizreach.jdynamo.data.mapper.DynamoIntegerMapper;
import jp.co.bizreach.jdynamo.data.mapper.DynamoIntegerSetMapper;
import jp.co.bizreach.jdynamo.data.mapper.DynamoLongListMapper;
import jp.co.bizreach.jdynamo.data.mapper.DynamoLongMapper;
import jp.co.bizreach.jdynamo.data.mapper.DynamoLongSetMapper;
import jp.co.bizreach.jdynamo.data.mapper.DynamoStringMapper;
import jp.co.bizreach.jdynamo.data.mapper.DynamoStringSetMapper;
import jp.co.bizreach.jdynamo.data.mapper.IDynamoMapper;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * Dynamo のレコードに使用するマッピング情報を定義したクラスです。
 * Created by iwami on 2016/07/01.
 */
public enum DynamoMappingAttributeType {

    STRING(new DynamoStringMapper()),

    LONG(new DynamoLongMapper()),
    INTEGER(new DynamoIntegerMapper()),
    DECIMAL(new DynamoDecimalMapper()),

    BOOLEAN(new DynamoBooleanMapper()),
    DATE(new DynamoDateMapper()),
    DATETIME(new DynamoDateTimeMapper()),

    /** 文字列を圧縮して Dynamo の Binary 型で格納 */
    COMPRESS_STRING(new DynamoCompressStringMapper()),

    STRING_SET(new DynamoStringSetMapper()),
    INTEGER_SET(new DynamoIntegerSetMapper()),
    LONG_SET(new DynamoLongSetMapper()),

    LONG_LIST(new DynamoLongListMapper()),

    UNKNOWN(new UnknownDynamoMapper());

    private IDynamoMapper mapper;

    private DynamoMappingAttributeType(IDynamoMapper mapper) {
        this.mapper = mapper;
    }

    public static DynamoMappingAttributeType fieldOf(Field field) {
        for (DynamoMappingAttributeType type : values()) {
            if (type.isMatch(field)) {
                return type;
            }
        }
        return UNKNOWN;
    }

    private boolean isMatch(Field field) {
        return mapper.isMatch(field);
    }

    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        mapper.appendValue(results, key, value);
    }

    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        mapper.storeField(record, fieldName, value);
    }

    public AttributeValue createAttributeValue(Object value) {
        return mapper.createAttributeValue(value);
    }

    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        return mapper.createAttributeDefinition(dynamoName);
    }

    public boolean isList() {
        return mapper.isList();
    }
}
