package jp.co.bizreach.jdynamo.data.attr;

import jp.co.bizreach.jdynamo.data.DynamoUpdateValue;
import jp.co.bizreach.jdynamo.data.DynamoAttributeDefinition;

import java.util.Arrays;

/**
 * Created by iwami on 2016/07/01.
 */
public abstract class AbstractDynamoAttributeSupport implements DynamoAttributeSupport {

    private DynamoAttributeDefinition attr;

    public AbstractDynamoAttributeSupport(DynamoAttributeDefinition attr) {
        this.attr = attr;
    }

    @Override
    public String getDynamoAttrName() {
        return attr.getDynamoAttrName();
    }

    @Override
    public DynamoAttributeWithValue eq(Object targetValue) {
        return middle(targetValue, " = ");
    }

    @Override
    public DynamoAttributeWithValue ne(Object targetValue) {
        return middle(targetValue, " <> ");
    }

    @Override
    public DynamoAttributeWithValue contains(Object targetValue) {
        throw new IllegalArgumentException(attr.getMappingType() + " attribute is not support 'contains'.");
    }

    @Override
    public DynamoAttributeWithValue in(Object... targetValues) {
        return middle(Arrays.asList(targetValues), " in ");
    }

    @Override
    public DynamoAttributeWithValue greaterThan(Object targetValue) {
        return middle(targetValue, " > ");
    }

    @Override
    public DynamoAttributeWithValue greaterThanEq(Object targetValue) {
        return middle(targetValue, " >= ");
    }

    @Override
    public DynamoAttributeWithValue lessThan(Object targetValue) {
        return middle(targetValue, " < ");
    }

    @Override
    public DynamoAttributeWithValue lessThanEq(Object targetValue) {
        return middle(targetValue, " <= ");
    }

    @Override
    public DynamoAttributeWithValue exists() {
        return leftMiddle("attribute_exists (", ")");
    }

    @Override
    public DynamoAttributeWithValue notExists() {
        return leftMiddle("attribute_not_exists (", ")");
    }

    @Override
    public DynamoUpdateValue set(Object value) {
        return new DynamoUpdatePutValue(attr.getMappingType(), attr.getDynamoAttrName(), value);
    }

    @Override
    public DynamoUpdateValue setIfNotExists(Object value) {
        return new DynamoUpdateIfNotExistsValue(attr.getMappingType(), attr.getDynamoAttrName(), value);
    }

    @Override
    public DynamoUpdateValue increment(Integer delta) {
        return new DynamoUpdateIncrValue(attr.getMappingType(), attr.getDynamoAttrName(), delta);
    }

    @Override
    public DynamoUpdateValue add(Integer delta) {
        return new DynamoUpdateAddValue(attr.getMappingType(), attr.getDynamoAttrName(), delta);
    }

    @Override
    public DynamoUpdateValue append(Long value) {
        return new DynamoUpdateAppendValue(attr.getMappingType(), attr.getDynamoAttrName(), value);
    }

    @Override
    public DynamoUpdateValue append(String value) {
        return new DynamoUpdateAppendValue(attr.getMappingType(), attr.getDynamoAttrName(), value);
    }

    @Override
    public DynamoUpdateValue delete(Long value) {
        return new DynamoUpdateDeleteValue(attr.getDynamoAttrName(), value);
    }

    @Override
    public DynamoUpdateValue clear() {
        return new DynamoUpdateRemoveValue(attr.getDynamoAttrName());
    }

    protected DynamoAttributeWithValue middle(Object targetValue, String m) {
        DynamoAttributeWithValue value = new DynamoAttributeWithValue(attr);
        value.setTargetValue(targetValue);
        value.setMiddleOperatorStr(m);
        value.setValueExist(true);
        return value;
    }


    protected DynamoAttributeWithValue leftMiddle(String left, String middle) {
        DynamoAttributeWithValue value = new DynamoAttributeWithValue(attr);
        value.setLeftOperatorStr(left);
        value.setMiddleOperatorStr(middle);
        return value;
    }

    protected DynamoAttributeWithValue leftMiddleRightValue(String left, String middle, String right,
                                                            Object targetValue) {
        DynamoAttributeWithValue value = new DynamoAttributeWithValue(attr);
        value.setLeftOperatorStr(left);
        value.setMiddleOperatorStr(middle);
        value.setRightOperatorStr(right);
        value.setTargetValue(targetValue);
        value.setValueExist(true);
        return value;
    }

}
