package jp.co.bizreach.jdynamo.data.attr;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.data.DynamoUpdateValue;

import java.util.Map;

/**
 * Created by iwami on 2016/11/22.
 */
public abstract class AbstractDynamoUpdateValue implements DynamoUpdateValue {

    protected DynamoMappingAttributeType mappingType;
    private String dynamoAttrName;

    protected AbstractDynamoUpdateValue(DynamoMappingAttributeType mappingType, String dynamoAttrName) {
        this.mappingType = mappingType;
        this.dynamoAttrName = dynamoAttrName;
    }

    @Override
    public void appendAdditionalAttributeValues(Map<String, AttributeValue> map) {
        // do nothing (override extends class)
    }

    @Override
    public String getName() {
        return dynamoAttrName;
    }

}
