package jp.co.bizreach.jdynamo.data.attr;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import jp.co.bizreach.jdynamo.data.DynamoAttributeDefinition;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * Created by iwami on 2016/07/04.
 */
@Setter
public class DynamoAttributeWithValue {

    private static final String FNAME = "#fname";

    @Getter
    private DynamoAttributeDefinition attributeDefinition;

    @Getter
    private DynamoMappingAttributeType attributeType;

    @Getter
    private String dynamoAttrName;

    @Getter
    private Object targetValue;

    private boolean valueExist;

    private String leftOperatorStr;

    private String middleOperatorStr;

    private String rightOperatorStr;

    public DynamoAttributeWithValue(DynamoAttributeDefinition attributeDefinition) {
        this.attributeDefinition = attributeDefinition;
        attributeType = attributeDefinition.getMappingType();
        dynamoAttrName = attributeDefinition.getDynamoAttrName();
    }

    public String getExpression(List<Integer> indexes) {
        StringBuilder sb = new StringBuilder();
        if (leftOperatorStr != null) {
            sb.append(leftOperatorStr);
        }
        String index = StringUtils.join(indexes, "_");
        sb.append(FNAME).append(index);
        if (middleOperatorStr != null) {
            sb.append(middleOperatorStr);
        }
        if (valueExist) {
            if (targetValue instanceof List) {
                appendListExpression(sb, index);
            } else {
                sb.append(":fvalue").append(index);
            }
        }
        if (rightOperatorStr != null) {
            sb.append(rightOperatorStr);
        }

        return sb.toString();
    }

    private void appendListExpression(StringBuilder sb, String index) {
        int size = ((List)targetValue).size();
        // (:cat1, :cat2)
        sb.append('(');
        for (int i = 0 ; i < size; i++) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(":fvalue").append(index).append('L').append(Integer.toString(i));
        }
        sb.append(')');
    }

    public void appendAttributeNames(Map<String, String> names, Integer idx) {
        names.put(FNAME + idx, attributeDefinition.getDynamoAttrName());
    }

    public void appendAttributeValues(Map<String, AttributeValue> values, Integer idx) {
        attributeType.appendValue(values, ":fvalue" + idx, targetValue);
    }

}
