package jp.co.bizreach.jdynamo.data.attr;

import jp.co.bizreach.jdynamo.data.DynamoAttributeDefinition;

/**
 * Created by iwami on 2016/07/14.
 */
public class DynamoIntegerSetAttribute extends AbstractDynamoAttributeSupport {

    public DynamoIntegerSetAttribute(DynamoAttributeDefinition attr) {
        super(attr);
    }

    @Override
    public DynamoAttributeWithValue eq(Object targetValue) {
        throw new IllegalArgumentException(
                "INTEGER_SET attribute is not support 'eq'. please use 'contains' instead.");
    }

    public DynamoAttributeWithValue contains(Object targetValue) {
        if (targetValue instanceof Integer == false) {
            throw new IllegalArgumentException("targetValue must be Integer.");
        }
        return leftMiddleRightValue("contains (", ", ", ")", targetValue);
    }

}
