package jp.co.bizreach.jdynamo.data.attr;

import jp.co.bizreach.jdynamo.data.DynamoAttributeDefinition;

/**
 * Created by iwami on 2016/11/22.
 */
public class DynamoLongListAttribute extends AbstractDynamoAttributeSupport {

    public DynamoLongListAttribute(DynamoAttributeDefinition attr) {
        super(attr);
    }

    @Override
    public DynamoAttributeWithValue eq(Object targetValue) {
        throw new IllegalArgumentException(
                "LONG_LIST attribute is not support 'eq'. please use 'contains' instead.");
    }

    public DynamoAttributeWithValue contains(Object targetValue) {
        if (targetValue instanceof Long == false) {
            throw new IllegalArgumentException("targetValue must be Long.");
        }
        return leftMiddleRightValue("contains (", ", ", ")", targetValue);
    }

}
