package jp.co.bizreach.jdynamo.data.attr;

import jp.co.bizreach.jdynamo.data.DynamoAttributeDefinition;

/**
 * Created by iwami on 2016/07/06.
 */
public class DynamoStringSetAttribute extends AbstractDynamoAttributeSupport {

    public DynamoStringSetAttribute(DynamoAttributeDefinition attr) {
        super(attr);
    }

    @Override
    public DynamoAttributeWithValue eq(Object targetValue) {
        throw new IllegalArgumentException("STRING_SET attribute is not support 'eq'. please use 'contains' instead.");
    }

    public DynamoAttributeWithValue contains(Object targetValue) {
        if (targetValue instanceof String == false) {
            throw new IllegalArgumentException("targetValue must be String.");
        }
        return leftMiddleRightValue("contains (", ", ", ")", targetValue);
    }

}
