package jp.co.bizreach.jdynamo.data.attr;

import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.util.DynamoAttributeUtil;

/**
 * Created by iwami on 2016/11/18.
 */
/* package */ public class DynamoUpdateAddValue extends AbstractDynamoUpdateValue {

    private Number delta;

    public DynamoUpdateAddValue(DynamoMappingAttributeType mappingType, String dynamoAttrName, Number delta) {
        super(mappingType, dynamoAttrName);
        this.delta = delta;
    }

    @Override
    public String createUpdateExpression(int idx) {
        return "#uname" + idx + " :uval" + idx;
    }

    @Override
    public boolean hasAttributeValue() {
        return true;
    }

    @Override
    public UpdateCategory getUpdateCategory() {
        return UpdateCategory.ADD;
    }

    @Override
    public Object getValue() {
        return delta;
    }

    @Override
    public AttributeValueUpdate getAttributeValue() {
        return DynamoAttributeUtil.createAttributeValueUpdate(mappingType, delta);
    }
}
