package jp.co.bizreach.jdynamo.data.attr;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.util.DynamoAttributeUtil;

import java.util.Map;

/**
 * Created by iwami on 2016/11/18.
 */
/* package */ public class DynamoUpdateAppendValue extends AbstractDynamoUpdateValue {

    private Number nvalue;
    private String svalue;

    public DynamoUpdateAppendValue(DynamoMappingAttributeType mappingType, String dynamoAttrName, Number value) {
        super(mappingType, dynamoAttrName);
        this.nvalue = value;
    }

    public DynamoUpdateAppendValue(DynamoMappingAttributeType mappingType, String dynamoAttrName, String value) {
        super(mappingType, dynamoAttrName);
        this.svalue = value;
    }

    @Override
    public String createUpdateExpression(int idx) {
//        return "#uname" + idx + " = list_append(#uname" + idx + ", :uval" + idx + ")";
        if (mappingType.isList()) {
            return "#uname" + idx + " = list_append(if_not_exists(#uname" + idx + ", :_empty_list), :uval" + idx + ")";
        }
        return "#uname" + idx + " :uval" + idx;

        // 'SET my_list2 = list_append(if_not_exists(my_list2, :empty_list), :my_value)'
    }

    @Override
    public void appendAdditionalAttributeValues(Map<String, AttributeValue> map) {
        super.appendAdditionalAttributeValues(map);
        if (mappingType.isList()) {
            map.put(":_empty_list", new AttributeValue().withL());
        }
    }

    @Override
    public boolean hasAttributeValue() {
        return true;
    }

    @Override
    public UpdateCategory getUpdateCategory() {
        if (mappingType.isList()) {
            return UpdateCategory.SET;
        }
        return UpdateCategory.ADD;
    }

    @Override
    public Object getValue() {
        return nvalue != null ? nvalue : svalue;
    }

    @Override
    public AttributeValueUpdate getAttributeValue() {
        if (nvalue != null) {
            return DynamoAttributeUtil.createAttributeValueUpdate(mappingType, nvalue);
        }
        return DynamoAttributeUtil.createAttributeValueUpdate(mappingType, svalue);
    }
}
