package jp.co.bizreach.jdynamo.data.attr;

import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;

/**
 * Created by iwami on 2016/07/04.
 */
/* package */ class DynamoUpdateDeleteValue extends AbstractDynamoUpdateValue {

    private Number value;

    public DynamoUpdateDeleteValue(String dynamoAttrName, Number value) {
        super(null, dynamoAttrName);
        this.value = value;
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public boolean hasAttributeValue() {
        return true;
    }

    @Override
    public AttributeValueUpdate getAttributeValue() {
        return new AttributeValueUpdate().withAction(AttributeAction.DELETE)
                .withValue(new AttributeValue().withNS(value.toString()));
    }

    @Override
    public UpdateCategory getUpdateCategory() {
        return UpdateCategory.DELETE;
    }

    @Override
    public String createUpdateExpression(int idx) {
        // return "#uname" + idx + " = :uval" + idx;
        return "#uname" + idx + " :uval" + idx;
        //return dynamoAttrName;
    }

}
