package jp.co.bizreach.jdynamo.data.attr;

import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.util.DynamoAttributeUtil;

/**
 * Created by iwami on 2016/07/04.
 */
/* package */ class DynamoUpdatePutValue extends AbstractDynamoUpdateValue {

    private Object value;

    public DynamoUpdatePutValue(DynamoMappingAttributeType mappingType, String dynamoAttrName, Object value) {
        super(mappingType, dynamoAttrName);
        this.value = value;
    }

    @Override
    public String createUpdateExpression(int idx) {
        return "#uname" + idx + " = :uval" + idx;
    }

    @Override
    public boolean hasAttributeValue() {
        return true;
    }

    @Override
    public UpdateCategory getUpdateCategory() {
        return UpdateCategory.SET;
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public AttributeValueUpdate getAttributeValue() {
        return DynamoAttributeUtil.createAttributeValueUpdate(mappingType, value);
    }

}
