package jp.co.bizreach.jdynamo.data.attr;

import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;

/**
 * Created by iwami on 2016/07/04.
 */
/* package */ class DynamoUpdateRemoveValue extends AbstractDynamoUpdateValue {

    public DynamoUpdateRemoveValue(String dynamoAttrName) {
        super(null, dynamoAttrName);
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public boolean hasAttributeValue() {
        return false;
    }

    @Override
    public AttributeValueUpdate getAttributeValue() {
        return new AttributeValueUpdate().withAction(AttributeAction.DELETE);
    }

    @Override
    public UpdateCategory getUpdateCategory() {
        return UpdateCategory.REMOVE;
    }

    @Override
    public String createUpdateExpression(int idx) {
        // return "#uname" + idx + " = :uval" + idx;
        return "#uname" + idx;
        //return dynamoAttrName;
    }

}
