package jp.co.bizreach.jdynamo.data.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import jp.co.bizreach.jdynamo.DynamoRuntimeException;
import org.apache.commons.beanutils.PropertyUtils;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * Created by iwami on 2016/07/15.
 */
public class DynamoBooleanMapper implements IDynamoMapper {

    @Override
    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        results.put(key, new AttributeValue().withBOOL( (Boolean)value));
    }

    @Override
    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        PropertyUtils.setProperty(record, fieldName, value.getBOOL());
    }

    @Override
    public boolean isMatch(Field field) {
        return Boolean.class.equals(field.getType());
    }

    @Override
    public AttributeValue createAttributeValue(Object value) {
        return new AttributeValue().withBOOL((Boolean)value);
    }

    @Override
    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        throw new DynamoRuntimeException("Boolean is not support.");
    }

    @Override
    public boolean isList() {
        return false;
    }

}
