package jp.co.bizreach.jdynamo.data.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import jp.co.bizreach.jdynamo.DynamoRuntimeException;
import org.apache.commons.beanutils.PropertyUtils;

import java.lang.reflect.Field;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;

/**
 * Created by iwami on 2016/07/15.
 */
public class DynamoDateMapper implements IDynamoMapper {

    @Override
    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        if (value instanceof Date) {
            results.put(key, new AttributeValue().withN( Long.toString(((Date)value).getTime())));
        }
        if (value instanceof LocalDate) {
            long day = ((LocalDate) value).toEpochDay();
            results.put(key, new AttributeValue().withN(Long.toString(day)));
        }
    }

    @Override
    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        long eday = Long.parseLong(value.getN());
        Class<?> propertyType = PropertyUtils.getPropertyType(record, fieldName);
        if (LocalDate.class.equals(propertyType)) {
            PropertyUtils.setProperty(record, fieldName, LocalDate.ofEpochDay(eday));
        }
        if (Date.class.equals(propertyType)) {
            PropertyUtils.setProperty(record, fieldName, new Date(eday));
        }

    }

    @Override
    public boolean isMatch(Field field) {
        return LocalDate.class.equals(field.getType()) || Date.class.equals(field.getType());
    }

    @Override
    public AttributeValue createAttributeValue(Object value) {
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate) value;
            return new AttributeValue().withN(Long.toString(localDate.toEpochDay()));
        }
        if (value instanceof Date) {
            Date date = (Date) value;
            return new AttributeValue().withN(Long.toString(date.getTime()));
        }
        throw new DynamoRuntimeException(value.getClass() + " is not match date mapper.");
    }

    @Override
    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        return new AttributeDefinition(dynamoName, ScalarAttributeType.N);
    }

    @Override
    public boolean isList() {
        return false;
    }

}
