package jp.co.bizreach.jdynamo.data.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import org.apache.commons.beanutils.PropertyUtils;

import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

/**
 * Created by iwami on 2016/07/15.
 */
public class DynamoDateTimeMapper implements IDynamoMapper {

    @Override
    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        if (value instanceof LocalDateTime) {
            long second = ((LocalDateTime)value).toLocalDate().toEpochDay() * 60 * 60 * 24
                    + ((LocalDateTime)value).toLocalTime().toSecondOfDay();
            results.put(key, new AttributeValue().withN(Long.toString(second)));
        }
    }

    @Override
    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        long esecond = Long.parseLong(value.getN());
        long time = esecond % (60 * 60 * 24);
        long day = esecond / (60 * 60 * 24);
        LocalDateTime dateTime = LocalDateTime.of(LocalDate.ofEpochDay(day), LocalTime.ofSecondOfDay(time));
        PropertyUtils.setProperty(record, fieldName, dateTime);
    }

    @Override
    public boolean isMatch(Field field) {
        return LocalDateTime.class.equals(field.getType());
    }

    @Override
    public AttributeValue createAttributeValue(Object value) {
        AttributeValue attrValue = new AttributeValue();
        long second = ((LocalDateTime)value).toLocalDate().toEpochDay() * 60 * 60 * 24
                + ((LocalDateTime)value).toLocalTime().toSecondOfDay();
        attrValue.withN(Long.toString(second));
        return attrValue;
    }

    @Override
    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        return new AttributeDefinition(dynamoName, ScalarAttributeType.N);
    }

    @Override
    public boolean isList() {
        return false;
    }

}
