package jp.co.bizreach.jdynamo.data.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import org.apache.commons.beanutils.PropertyUtils;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Map;

/**
 * Created by iwami on 2016/11/22.
 */
public class DynamoDecimalMapper implements IDynamoMapper {

    @Override
    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        results.put(key, new AttributeValue().withS(((BigDecimal)value).toPlainString()));
    }

    @Override
    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        PropertyUtils.setProperty(record, fieldName, new BigDecimal(value.getS()));
    }

    @Override
    public boolean isMatch(Field field) {
        return BigDecimal.class.equals(field.getType());
    }

    @Override
    public AttributeValue createAttributeValue(Object value) {
        return new AttributeValue().withS(value.toString());
    }

    @Override
    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        return new AttributeDefinition(dynamoName, ScalarAttributeType.S);
    }

    @Override
    public boolean isList() {
        return false;
    }

}
