package jp.co.bizreach.jdynamo.data.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import org.apache.commons.beanutils.PropertyUtils;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * Created by iwami on 2016/07/15.
 */
public class DynamoIntegerMapper implements IDynamoMapper {

    @Override
    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        results.put(key, new AttributeValue().withN(Integer.toString((Integer)value)));
    }

    @Override
    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        PropertyUtils.setProperty(record, fieldName, Integer.valueOf(value.getN()));
    }

    @Override
    public boolean isMatch(Field field) {
        return Integer.class.equals(field.getType());
    }

    @Override
    public AttributeValue createAttributeValue(Object value) {
        return new AttributeValue().withN(value.toString());
    }

    @Override
    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        return new AttributeDefinition(dynamoName, ScalarAttributeType.N);
    }

    @Override
    public boolean isList() {
        return false;
    }

}
