package jp.co.bizreach.jdynamo.data.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import jp.co.bizreach.jdynamo.DynamoRuntimeException;
import org.apache.commons.beanutils.PropertyUtils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Created by iwami on 2016/07/15.
 */
public class DynamoLongSetMapper implements IDynamoMapper {

    @Override
    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        if (value instanceof Long) {
            results.put(key, new AttributeValue().withN(Long.toString((Long)value)));
        }
    }

    @Override
    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        PropertyUtils.setProperty(record, fieldName,
                new HashSet<Long>(value.getNS().stream()
                        .map(Long::valueOf).collect(Collectors.toList())));
    }

    @Override
    public boolean isMatch(Field field) {
        Class<?> clazz = field.getType();
        if (Set.class.equals(clazz)) {
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                Type type = ((ParameterizedType) genericType).getActualTypeArguments()[0];
                if (Long.class.equals(type)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public AttributeValue createAttributeValue(Object value) {
        if (value instanceof Long) {
            return new AttributeValue().withNS(String.valueOf((Long)value));
        }
        return new AttributeValue().withNS(
                ((Set<Long>) value).stream().map(i -> i.toString()).collect(Collectors.toList()));

    }

    @Override
    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        throw new DynamoRuntimeException("Set<Long> is not support.");
    }
    @Override
    public boolean isList() {
        return false;
    }

}
