package jp.co.bizreach.jdynamo.data.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import jp.co.bizreach.jdynamo.annotation.Compress;
import org.apache.commons.beanutils.PropertyUtils;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * Created by iwami on 2016/07/15.
 */
public class DynamoStringMapper implements IDynamoMapper {

    @Override
    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        results.put(key, new AttributeValue().withS(value.toString()));
    }

    @Override
    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        PropertyUtils.setProperty(record, fieldName, value.getS());
    }

    @Override
    public boolean isMatch(Field field) {
        return String.class.equals(field.getType()) && field.getAnnotation(Compress.class) == null;
    }

    @Override
    public AttributeValue createAttributeValue(Object value) {
        return new AttributeValue().withS((String)value);
    }

    @Override
    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        return new AttributeDefinition(dynamoName, ScalarAttributeType.S);
    }

    @Override
    public boolean isList() {
        return false;
    }

}
