package jp.co.bizreach.jdynamo.data.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import jp.co.bizreach.jdynamo.DynamoRuntimeException;
import org.apache.commons.beanutils.PropertyUtils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by iwami on 2016/07/15.
 */
public class DynamoStringSetMapper implements IDynamoMapper {

    @Override
    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        if (value instanceof String) {
            results.put(key, new AttributeValue().withS((String)value));
        }
    }

    @Override
    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        PropertyUtils.setProperty(record, fieldName, new HashSet<String>(value.getSS()));
    }

    @Override
    public boolean isMatch(Field field) {
        Class<?> clazz = field.getType();
        if (Set.class.equals(clazz)) {
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                Type type = ((ParameterizedType) genericType).getActualTypeArguments()[0];
                if (String.class.equals(type)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public AttributeValue createAttributeValue(Object value) {
        if (value instanceof String) {
            return new AttributeValue().withSS(value.toString());
        }
        return new AttributeValue().withSS((Set)value);
    }

    @Override
    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        throw new DynamoRuntimeException("Set<String> is not support.");
    }

    @Override
    public boolean isList() {
        return false;
    }

}
