package jp.co.bizreach.jdynamo.util;

import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * Created by iwami on 2016/07/01.
 */
@Slf4j
public class DynamoAttributeUtil {

    private DynamoAttributeUtil() {
        // do nothing
    }

    public static AttributeValue createAttributeValue(DynamoMappingAttributeType mappingType, Object value) {
        return mappingType.createAttributeValue(value);
    }

    public static void appendValue(Map<String, AttributeValue> results, DynamoMappingAttributeType attrType,
                                   String key, Object value) {
        attrType.appendValue(results, key, value);
    }

    public static AttributeValueUpdate createAttributeValueUpdate(DynamoMappingAttributeType mappingType, Object value) {
        AttributeValueUpdate attrValue = new AttributeValueUpdate();
        attrValue.withValue(createAttributeValue(mappingType, value));
        attrValue.withAction(AttributeAction.PUT);
        return attrValue;
    }

}
