package jp.co.bizreach.jdynamo.util;

/**
 * Created by iwami on 2016/06/30.
 */
public interface DynamoTableNameResolver {

    String resolveTableName(String baseTableName);

    public static class TableNamePrefixResolver implements  DynamoTableNameResolver {

        private String tablePrefix;

        public TableNamePrefixResolver(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }

        @Override
        public String resolveTableName(String baseTableName) {
            return tablePrefix + baseTableName;
        }
    }

}
