/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo;

import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.bizreach.jdynamo.DynamoClientSetting;
import jp.co.bizreach.jdynamo.DynamoConditionalCheckFailedException;
import jp.co.bizreach.jdynamo.action.DynamoQuery;
import jp.co.bizreach.jdynamo.action.DynamoScan;
import jp.co.bizreach.jdynamo.action.DynamoUpdateChain;
import jp.co.bizreach.jdynamo.admin.DynamoAdminClient;
import jp.co.bizreach.jdynamo.core.DynamoAppEnvirionment;
import jp.co.bizreach.jdynamo.core.DynamoThroughputAdjuster;
import jp.co.bizreach.jdynamo.data.DynamoAttributeDefinition;
import jp.co.bizreach.jdynamo.data.DynamoIndex;
import jp.co.bizreach.jdynamo.data.DynamoKey;
import jp.co.bizreach.jdynamo.data.DynamoMetaTable;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeWithValue;
import jp.co.bizreach.jdynamo.util.DynamoAttributeUtil;
import jp.co.bizreach.jdynamo.util.DynamoCloudWatchClient;
import jp.co.bizreach.jdynamo.util.DynamoTableNameResolver;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoClient {
    private static final Logger log = LoggerFactory.getLogger(DynamoClient.class);
    private AmazonDynamoDBClient amazonDynamoClient;
    private DynamoAppEnvirionment appEnvironment;
    private DynamoAdminClient adminClient;
    private DynamoClientSetting clientSetting;
    private DynamoCloudWatchClient cloudWatchClient;
    private DynamoTableNameResolver tableNameResolver;
    private DynamoClientPrivate clientPrivate = new DynamoClientPrivate();

    public DynamoClient(AmazonDynamoDBClient dynamoClient, DynamoAppEnvirionment env) {
        this.amazonDynamoClient = dynamoClient;
        this.appEnvironment = env;
        this.clientSetting = new DynamoClientSetting();
        this.tableNameResolver = new DynamoTableNameResolver.TableNamePrefixResolver("");
        log.info("DynamoClient created.");
    }

    public DescribeTableResult describeTable(DynamoMetaTable table) {
        return this.amazonDynamoClient.describeTable(this.clientPrivate.getRealTableName(table));
    }

    public void enableCloudWatchClient(AmazonCloudWatchClient dynamoCloudWatchClient) {
        this.cloudWatchClient = new DynamoCloudWatchClient(this.clientPrivate, dynamoCloudWatchClient);
    }

    public DynamoAdminClient useAdminClient() {
        if (this.appEnvironment != DynamoAppEnvirionment.LOCAL) {
            throw new IllegalStateException("useAdminClient() is only usable for LOCAL mode");
        }
        if (this.adminClient == null) {
            this.adminClient = new DynamoAdminClient(this.amazonDynamoClient, this.clientPrivate);
        }
        return this.adminClient;
    }

    public void put(DynamoMetaTable table, Object record) {
        PutItemRequest request = this.makePutItemRequest(table, record);
        if (log.isDebugEnabled()) {
            log.debug(request.toString());
        }
        this.amazonDynamoClient.putItem(request);
    }

    public void putWithAdjustThroughput(DynamoMetaTable table, Object record) {
        PutItemRequest request = this.makePutItemRequest(table, record);
        if (log.isDebugEnabled()) {
            log.debug(request.toString());
        }
        new DynamoThroughputAdjuster(this.amazonDynamoClient).put(request);
    }

    public int batchPut(DynamoMetaTable table, List<Object> records) {
        BatchWriteItemResult result = this.amazonDynamoClient.batchWriteItem(this.makeBatchPutItemRequest(table, records));
        if (result.getUnprocessedItems().isEmpty()) {
            return 0;
        }
        return result.getUnprocessedItems().entrySet().stream().mapToInt(entry -> ((List)entry.getValue()).size()).sum();
    }

    public void batchPutWithAdjustThroughput(DynamoMetaTable table, List<Object> records) {
        BatchWriteItemResult result = this.amazonDynamoClient.batchWriteItem(this.makeBatchPutItemRequest(table, records));
        while (!result.getUnprocessedItems().isEmpty()) {
            log.info("found unprocessedItems. retry BatchWriteItemRequest.");
            result = this.innerBatchPutWithAdjustThroughput(table, result.getUnprocessedItems());
        }
    }

    public void batchPutWithSplit(DynamoMetaTable table, List<Object> records) {
        List partition = ListUtils.partition(records, (int)25);
        for (List dynamoRecords : partition) {
            BatchWriteItemRequest rawRequest = this.makeBatchPutItemRequest(table, dynamoRecords);
            BatchWriteItemResult result = new DynamoThroughputAdjuster(this.amazonDynamoClient).batchPut(rawRequest);
            while (!result.getUnprocessedItems().isEmpty()) {
                int size = result.getUnprocessedItems().entrySet().stream().mapToInt(entry -> ((List)entry.getValue()).size()).sum();
                log.info("found unprocessedItems (" + size + "). retry BatchWriteItemRequest.");
                result = this.innerBatchPutWithAdjustThroughput(table, result.getUnprocessedItems());
            }
        }
    }

    public void simpleUpdate(DynamoMetaTable table, DynamoKey key, Object record) {
        this.amazonDynamoClient.updateItem(this.makeUpdateItemRequest(table, key, record));
    }

    public void delete(DynamoMetaTable table, DynamoKey key) {
        this.amazonDynamoClient.deleteItem(this.makeDeleteItemRequest(table, key, null));
    }

    public void delete(DynamoMetaTable table, DynamoKey key, DynamoAttributeWithValue condition) {
        this.amazonDynamoClient.deleteItem(this.makeDeleteItemRequest(table, key, condition));
    }

    public int batchDelete(DynamoMetaTable table, List<DynamoKey> keys) {
        BatchWriteItemResult result = this.amazonDynamoClient.batchWriteItem(this.makeBatchDeleteRequest(table, keys));
        if (result.getUnprocessedItems().isEmpty()) {
            return 0;
        }
        Collection values = result.getUnprocessedItems().values();
        int count = 0;
        for (List list : values) {
            count += list.size();
        }
        return count;
    }

    public DynamoUpdateChain updateChain(DynamoMetaTable table, DynamoKey key) {
        return new DynamoUpdateChain(this.clientPrivate, table, key);
    }

    public <T> DynamoUpdateChain updateChain(DynamoMetaTable<T> table, T rec) {
        DynamoKey key = table.createKey(rec);
        return this.updateChain(table, key);
    }

    public <T> T get(DynamoMetaTable<T> table, Object partitionKey, Object sortKey) {
        GetItemRequest request = new GetItemRequest().withTableName(this.clientPrivate.getRealTableName(table)).withKey(this.clientPrivate.createKey(table, partitionKey, sortKey));
        GetItemResult itemResult = this.amazonDynamoClient.getItem(request);
        return this.clientPrivate.toRecord(table, itemResult.getItem());
    }

    public <T> T get(DynamoMetaTable<T> table, Object partitionKey) {
        GetItemRequest request = new GetItemRequest().withTableName(this.clientPrivate.getRealTableName(table)).withKey(this.createKey(table, partitionKey));
        GetItemResult itemResult = this.amazonDynamoClient.getItem(request);
        return this.clientPrivate.toRecord(table, itemResult.getItem());
    }

    public <T> List<T> batchGet(DynamoMetaTable<T> table, List<DynamoKey> keys) {
        ArrayList<Map<String, AttributeValue>> dynamoKeys = new ArrayList<Map<String, AttributeValue>>();
        for (DynamoKey key : keys) {
            dynamoKeys.add(this.clientPrivate.createKey(table, key.getPartitionKey(), key.getSortKey()));
        }
        BatchGetItemRequest request = new BatchGetItemRequest().addRequestItemsEntry(this.clientPrivate.getRealTableName(table), new KeysAndAttributes().withKeys(dynamoKeys));
        BatchGetItemResult itemResult = this.amazonDynamoClient.batchGetItem(request);
        return this.clientPrivate.toRecords(table, (List)itemResult.getResponses().get(this.clientPrivate.getRealTableName(table)));
    }

    public <T> List<T> batchGetWithAdjustThroughput(DynamoMetaTable<T> table, List<DynamoKey> keys) {
        ArrayList<Map<String, AttributeValue>> dynamoKeys = new ArrayList<Map<String, AttributeValue>>();
        for (DynamoKey key : keys) {
            dynamoKeys.add(this.clientPrivate.createKey(table, key.getPartitionKey(), key.getSortKey()));
        }
        BatchGetItemRequest request = new BatchGetItemRequest().addRequestItemsEntry(this.clientPrivate.getRealTableName(table), new KeysAndAttributes().withKeys(dynamoKeys));
        BatchGetItemResult itemResult = new DynamoThroughputAdjuster(this.amazonDynamoClient).batchGet(request);
        ArrayList<T> results = new ArrayList<T>();
        results.addAll(this.clientPrivate.toRecords(table, (List)itemResult.getResponses().get(this.clientPrivate.getRealTableName(table))));
        while (!itemResult.getUnprocessedKeys().isEmpty()) {
            ArrayList<Map<String, AttributeValue>> unprocessedKeys = new ArrayList<Map<String, AttributeValue>>();
            Collection values = itemResult.getUnprocessedKeys().values();
            for (KeysAndAttributes value : values) {
                unprocessedKeys.addAll(value.getKeys());
            }
            log.info("found unprocessedKeys [size = " + unprocessedKeys.size() + "]. retry batchGet");
            itemResult = this.innerBatchGetWithAdjustThroughput(table, unprocessedKeys);
            results.addAll(this.clientPrivate.toRecords(table, (List)itemResult.getResponses().get(this.clientPrivate.getRealTableName(table))));
        }
        return results;
    }

    public <T> List<T> batchGetMany(DynamoMetaTable<T> table, List<DynamoKey> keys) {
        throw new UnsupportedOperationException("this method is not implemented.");
    }

    public <T> DynamoQuery<T> query(DynamoMetaTable<T> table) {
        return new DynamoQuery(this.clientPrivate, table);
    }

    public <T> DynamoQuery<T> query(DynamoMetaTable<T> table, DynamoIndex index) {
        return new DynamoQuery(this.clientPrivate, table, index);
    }

    public <T> DynamoScan<T> scan(DynamoMetaTable<T> table) {
        return new DynamoScan(this.clientPrivate, table);
    }

    public <T> ProvisionedThroughputDescription getProvisionedThroughput(DynamoMetaTable<T> table) {
        return this.clientPrivate.getTableProvisionedThroughput(table);
    }

    private <T> Map<String, AttributeValue> createKey(DynamoMetaTable<T> table, Object partitionKey) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        DynamoAttributeDefinition partitionKeyAttr = table.getPartitionKeyAttr();
        key.put(partitionKeyAttr.getDynamoAttrName(), DynamoAttributeUtil.createAttributeValue(partitionKeyAttr.getMappingType(), partitionKey));
        return key;
    }

    private <T> Map<String, AttributeValue> createDynamoKey(DynamoMetaTable<T> table, DynamoKey dynamoKey) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        DynamoAttributeDefinition partitionKeyAttr = table.getPartitionKeyAttr();
        DynamoAttributeDefinition sortKeyAttr = table.getSortKeyAttr();
        key.put(partitionKeyAttr.getDynamoAttrName(), DynamoAttributeUtil.createAttributeValue(partitionKeyAttr.getMappingType(), dynamoKey.getPartitionKey()));
        if (sortKeyAttr != null) {
            key.put(sortKeyAttr.getDynamoAttrName(), DynamoAttributeUtil.createAttributeValue(sortKeyAttr.getMappingType(), dynamoKey.getSortKey()));
        }
        return key;
    }

    private PutItemRequest makePutItemRequest(DynamoMetaTable table, Object record) {
        Map<String, AttributeValue> item = this.createItem(table, record);
        PutItemRequest request = new PutItemRequest().withTableName(this.clientPrivate.getRealTableName(table)).withItem(item);
        if (log.isDebugEnabled()) {
            log.debug("new PutItemRequest().\nitem = " + item);
        }
        return request;
    }

    private UpdateItemRequest makeUpdateItemRequest(DynamoMetaTable table, DynamoKey key, Object record) {
        return new UpdateItemRequest().withTableName(this.clientPrivate.getRealTableName(table)).withKey(this.createDynamoKey(table, key)).withAttributeUpdates(this.createUpdateItem(table, record));
    }

    private DeleteItemRequest makeDeleteItemRequest(DynamoMetaTable table, DynamoKey key, DynamoAttributeWithValue condition) {
        DeleteItemRequest request = new DeleteItemRequest();
        request.withTableName(this.clientPrivate.getRealTableName(table)).withKey(this.createDynamoKey(table, key));
        if (condition != null) {
            List<Integer> indexes = Arrays.asList(1);
            String expression = condition.getExpression(indexes);
            request.withConditionExpression(expression);
            HashMap<String, String> names = new HashMap<String, String>();
            condition.appendAttributeNames(names, 1);
            HashMap<String, AttributeValue> values = new HashMap<String, AttributeValue>();
            condition.appendAttributeValues(values, 1);
            request.withExpressionAttributeNames(names);
            request.withExpressionAttributeValues(values);
        }
        return request;
    }

    private Map<String, AttributeValue> createItem(DynamoMetaTable table, Object record) {
        return table.createItem(record);
    }

    private Map<String, AttributeValueUpdate> createUpdateItem(DynamoMetaTable table, Object record) {
        return table.createUpdateItem(record);
    }

    private BatchWriteItemResult innerBatchPutWithAdjustThroughput(DynamoMetaTable table, Map<String, List<WriteRequest>> unprocessedItems) {
        ArrayList<WriteRequest> writeRequests = new ArrayList<WriteRequest>();
        for (List<WriteRequest> list : unprocessedItems.values()) {
            writeRequests.addAll(list);
        }
        BatchWriteItemRequest rawRequest = new BatchWriteItemRequest().addRequestItemsEntry(this.clientPrivate.getRealTableName(table), writeRequests);
        BatchWriteItemResult result = new DynamoThroughputAdjuster(this.amazonDynamoClient).batchPut(rawRequest);
        return result;
    }

    private BatchWriteItemRequest makeBatchDeleteRequest(DynamoMetaTable table, List<DynamoKey> keys) {
        ArrayList<WriteRequest> requests = new ArrayList<WriteRequest>();
        for (DynamoKey key : keys) {
            requests.add(new WriteRequest(new DeleteRequest(this.createDynamoKey(table, key))));
        }
        return new BatchWriteItemRequest().addRequestItemsEntry(this.clientPrivate.getRealTableName(table), requests);
    }

    private BatchWriteItemRequest makeBatchPutItemRequest(DynamoMetaTable table, List<Object> records) {
        ArrayList<WriteRequest> requests = new ArrayList<WriteRequest>();
        for (Object record : records) {
            requests.add(new WriteRequest(new PutRequest(this.createItem(table, record))));
        }
        return new BatchWriteItemRequest().addRequestItemsEntry(this.clientPrivate.getRealTableName(table), requests);
    }

    private <T> BatchGetItemResult innerBatchGetWithAdjustThroughput(DynamoMetaTable<T> table, List<Map<String, AttributeValue>> unprocessedKeys) {
        BatchGetItemRequest request = new BatchGetItemRequest().addRequestItemsEntry(this.clientPrivate.getRealTableName(table), new KeysAndAttributes().withKeys(unprocessedKeys));
        BatchGetItemResult itemResult = new DynamoThroughputAdjuster(this.amazonDynamoClient).batchGet(request);
        return itemResult;
    }

    public DynamoClientSetting getClientSetting() {
        return this.clientSetting;
    }

    public DynamoCloudWatchClient getCloudWatchClient() {
        return this.cloudWatchClient;
    }

    public void setTableNameResolver(DynamoTableNameResolver tableNameResolver) {
        this.tableNameResolver = tableNameResolver;
    }

    public class DynamoClientPrivate {
        public AmazonDynamoDBClient getRawDynamoClient() {
            return DynamoClient.this.amazonDynamoClient;
        }

        public void executeUpdate(DynamoUpdateChain updateChain) {
            DynamoMetaTable table = updateChain.getTable();
            DynamoKey key = updateChain.getKey();
            UpdateItemRequest request = new UpdateItemRequest().withTableName(this.getRealTableName(table)).withKey(DynamoClient.this.createDynamoKey(table, key)).withReturnValues(ReturnValue.ALL_NEW);
            UpdateItemResult updateItemResult = DynamoClient.this.amazonDynamoClient.updateItem(updateChain.makeUpdateItemRequest(request));
            log.debug(updateItemResult.toString());
        }

        public UpdateItemResult executeUpdate(DynamoUpdateChain updateChain, ReturnValue returnValue) {
            DynamoMetaTable table = updateChain.getTable();
            DynamoKey key = updateChain.getKey();
            UpdateItemRequest request = new UpdateItemRequest().withTableName(this.getRealTableName(table)).withKey(DynamoClient.this.createDynamoKey(table, key)).withReturnValues(returnValue);
            try {
                UpdateItemResult updateItemResult = DynamoClient.this.amazonDynamoClient.updateItem(updateChain.makeUpdateItemRequest(request));
                return updateItemResult;
            }
            catch (ConditionalCheckFailedException e) {
                throw new DynamoConditionalCheckFailedException(e);
            }
        }

        public QueryResult rawQuery(QueryRequest queryRequest) {
            if (log.isDebugEnabled()) {
                log.debug("query start.");
            }
            QueryResult queryResult = DynamoClient.this.amazonDynamoClient.query(queryRequest);
            if (log.isDebugEnabled()) {
                log.debug("query finished. count = " + queryResult.getCount() + ", consumedCapacity = " + queryResult.getConsumedCapacity());
            }
            return queryResult;
        }

        public QueryResult rawQueryExponentialBackoff(QueryRequest queryRequest, DynamoThroughputAdjuster throughputAdjuster) {
            if (log.isDebugEnabled()) {
                log.debug("query start.");
            }
            QueryResult queryResult = throughputAdjuster.query(queryRequest);
            if (log.isDebugEnabled()) {
                log.debug("query finished. count = " + queryResult.getCount() + ", consumedCapacity = " + queryResult.getConsumedCapacity());
            }
            return queryResult;
        }

        public ScanResult rawScan(ScanRequest scanRequest, DynamoThroughputAdjuster throughputAdjuster) {
            return throughputAdjuster.scan(scanRequest);
        }

        public <T> List<T> toRecords(DynamoMetaTable<T> table, List<Map<String, AttributeValue>> items) {
            ArrayList<T> models = new ArrayList<T>();
            for (Map<String, AttributeValue> itemMap : items) {
                models.add(this.toRecord(table, itemMap));
            }
            return models;
        }

        public <T> T toRecord(DynamoMetaTable<T> table, Map<String, AttributeValue> itemMap) {
            if (itemMap == null) {
                return null;
            }
            try {
                Object record = ConstructorUtils.invokeConstructor(table.getRecordClass(), (Object[])new Object[0]);
                for (Map.Entry<String, AttributeValue> entry : itemMap.entrySet()) {
                    table.storeFieldByItem(record, entry, DynamoClient.this.clientSetting);
                }
                return (T)record;
            }
            catch (ReflectiveOperationException e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public <T> Map<String, AttributeValue> createKey(DynamoMetaTable<T> table, Object partitionKey, Object sortKey) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            DynamoAttributeDefinition partitionKeyAttr = table.getPartitionKeyAttr();
            DynamoAttributeDefinition sortKeyAttr = table.getSortKeyAttr();
            key.put(partitionKeyAttr.getDynamoAttrName(), DynamoAttributeUtil.createAttributeValue(partitionKeyAttr.getMappingType(), partitionKey));
            key.put(sortKeyAttr.getDynamoAttrName(), DynamoAttributeUtil.createAttributeValue(sortKeyAttr.getMappingType(), sortKey));
            return key;
        }

        public String getRealTableName(DynamoMetaTable table) {
            return DynamoClient.this.tableNameResolver.resolveTableName(table.getBaseTableName());
        }

        public ScanResult rawScan(ScanRequest scanRequest) {
            return DynamoClient.this.amazonDynamoClient.scan(scanRequest);
        }

        public <T> ProvisionedThroughputDescription getTableProvisionedThroughput(DynamoMetaTable<T> table) {
            DescribeTableRequest request = new DescribeTableRequest().withTableName(this.getRealTableName(table));
            DescribeTableResult describeTableResult = DynamoClient.this.amazonDynamoClient.describeTable(request);
            return describeTableResult.getTable().getProvisionedThroughput();
        }
    }
}

