/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.action;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.co.bizreach.jdynamo.DynamoClient;
import jp.co.bizreach.jdynamo.action.DynamoCondExpression;
import jp.co.bizreach.jdynamo.data.DynamoIndex;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.data.DynamoMetaTable;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeWithValue;

public class DynamoBaseAction<T> {
    protected DynamoClient.DynamoClientPrivate client;
    protected DynamoMetaTable table;
    protected DynamoIndex index;
    protected List<String> projectionNames = new ArrayList<String>();
    protected List<DynamoCondExpression> filterValues = new ArrayList<DynamoCondExpression>();
    protected Integer limit;

    public DynamoBaseAction(DynamoClient.DynamoClientPrivate client, DynamoMetaTable table) {
        this.client = client;
        this.table = table;
        this.index = table.getMainIndex();
    }

    public DynamoBaseAction(DynamoClient.DynamoClientPrivate client, DynamoMetaTable table, DynamoIndex index) {
        this.client = client;
        this.table = table;
        this.index = index;
    }

    protected boolean isTargetIndexPartition() {
        return this.index.getSortKeyDynamoName() == null;
    }

    protected String getIndexName() {
        return this.index.getIndexName();
    }

    protected String makeProjectionExpression() {
        if (this.projectionNames.isEmpty()) {
            return null;
        }
        return this.projectionNames.stream().collect(Collectors.joining(", "));
    }

    protected String makeFilterExpression() {
        StringBuilder sb = new StringBuilder();
        int lindex = 1;
        for (DynamoCondExpression expression : this.filterValues) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(expression.getExpressionText(Arrays.asList(lindex)));
            ++lindex;
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    protected void appendValue(Map<String, AttributeValue> results, DynamoMappingAttributeType attrType, String key, Object value) {
        if (value == null) {
            return;
        }
        attrType.appendValue(results, key, value);
    }

    protected void appendKeyValue(Map<String, AttributeValue> results, DynamoMappingAttributeType attrType, int idx, Object keyValue) {
        this.appendValue(results, attrType, ":kvalue" + idx, keyValue);
    }

    protected void appendFilterValue(Map<String, AttributeValue> results, DynamoMappingAttributeType attrType, int idx, Object filterValue) {
        if (filterValue instanceof DynamoAttributeWithValue) {
            this.appendValue(results, attrType, ":fvalue" + idx, ((DynamoAttributeWithValue)filterValue).getTargetValue());
        }
    }

    protected void appendFilterValue(Map<String, AttributeValue> results, DynamoCondExpression expression, List<Integer> indexes) {
        expression.appendValues(indexes, results);
    }

    protected static class RangeValue {
        protected Object from;
        protected Object to;

        RangeValue(Object from, Object to) {
            this.from = from;
            this.to = to;
        }
    }
}

