/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.action;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.bizreach.jdynamo.action.DynamoCondExpression;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeWithValue;
import jp.co.bizreach.jdynamo.util.DynamoAttributeUtil;
import org.apache.commons.lang3.StringUtils;

class DynamoFilterOr
implements DynamoCondExpression {
    private List<DynamoAttributeWithValue> conditions;

    public DynamoFilterOr(List<DynamoAttributeWithValue> conditions) {
        this.conditions = conditions;
    }

    @Override
    public String getExpressionText(List<Integer> indexes) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        int sidx = 0;
        for (DynamoAttributeWithValue cond : this.conditions) {
            ArrayList<Integer> subIndex = new ArrayList<Integer>(indexes);
            subIndex.add(sidx);
            sb.append(cond.getExpression(subIndex));
            sb.append(" OR ");
            ++sidx;
        }
        sb.setLength(sb.length() - 4);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getDynamoAttrName() {
        return null;
    }

    @Override
    public Object getTargetValue() {
        return null;
    }

    @Override
    public DynamoMappingAttributeType getMappingType() {
        return null;
    }

    @Override
    public void appendNames(List<Integer> indexes, Map<String, String> results) {
        int sidx = 0;
        for (DynamoAttributeWithValue cond : this.conditions) {
            ArrayList<Integer> subIndex = new ArrayList<Integer>(indexes);
            subIndex.add(sidx);
            results.put("#fname" + StringUtils.join(subIndex, (String)"_"), cond.getDynamoAttrName());
            ++sidx;
        }
    }

    @Override
    public void appendValues(List<Integer> indexes, Map<String, AttributeValue> results) {
        int sidx = 0;
        for (DynamoAttributeWithValue cond : this.conditions) {
            ArrayList<Integer> subIndex = new ArrayList<Integer>(indexes);
            subIndex.add(sidx);
            DynamoAttributeUtil.appendValue(results, cond.getAttributeType(), ":fvalue" + StringUtils.join(subIndex, (String)"_"), cond.getTargetValue());
            ++sidx;
        }
    }
}

