/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.action;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.Select;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.co.bizreach.jdynamo.DynamoClient;
import jp.co.bizreach.jdynamo.action.DynamoBaseAction;
import jp.co.bizreach.jdynamo.action.DynamoCondExpression;
import jp.co.bizreach.jdynamo.action.DynamoFilterOr;
import jp.co.bizreach.jdynamo.action.DynamoQueryValue;
import jp.co.bizreach.jdynamo.core.DynamoThroughputAdjuster;
import jp.co.bizreach.jdynamo.data.DynamoIndex;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.data.DynamoMetaTable;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeSupport;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeWithValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoQuery<T>
extends DynamoBaseAction<T> {
    private static final Logger log = LoggerFactory.getLogger(DynamoQuery.class);
    private static final String KNAME = "#kname";
    private List<DynamoQueryValue> keyValues = new ArrayList<DynamoQueryValue>();
    private DynamoThroughputAdjuster throughputAdjuster;
    private QueryResult lastQueryResult;
    private boolean enableLoggingInfo = false;

    public DynamoQuery(DynamoClient.DynamoClientPrivate client, DynamoMetaTable table) {
        super(client, table);
    }

    public DynamoQuery(DynamoClient.DynamoClientPrivate client, DynamoMetaTable table, DynamoIndex index) {
        super(client, table, index);
    }

    public DynamoQuery<T> key(Object partitionKey) {
        this.keyValues.add(new DynamoQueryValue(this.index.getPartitionAttributeDefinition(), partitionKey));
        return this;
    }

    public DynamoQuery<T> key(Object partitionKey, Object sortKey) {
        if (this.isTargetIndexPartition()) {
            throw new IllegalStateException("can't use sort-key. Because current context use partition-key index (not define sort-key)");
        }
        this.keyValues.add(new DynamoQueryValue(this.index.getPartitionAttributeDefinition(), partitionKey));
        this.keyValues.add(new DynamoQueryValue(this.index.getSortAttributeDefinition(), sortKey));
        return this;
    }

    public DynamoQuery<T> keyRange(Object partitionKey, Object sortKeyFrom, Object sortKeyTo) {
        this.keyValues.add(new DynamoQueryValue(this.index.getPartitionAttributeDefinition(), partitionKey));
        this.keyValues.add(new DynamoQueryValue(this.index.getSortAttributeDefinition(), new DynamoBaseAction.RangeValue(sortKeyFrom, sortKeyTo)));
        return this;
    }

    public DynamoQuery<T> filter(DynamoAttributeWithValue cond) {
        this.filterValues.add(new DynamoQueryValue(cond.getAttributeDefinition(), cond));
        return this;
    }

    public DynamoQuery<T> filterOr(DynamoAttributeWithValue ... conditions) {
        this.filterValues.add(new DynamoFilterOr(Arrays.asList(conditions)));
        return this;
    }

    public DynamoQuery<T> projection(DynamoAttributeSupport ... attrs) {
        List names;
        this.projectionNames = names = Arrays.stream(attrs).map(attr -> attr.getDynamoAttrName()).collect(Collectors.toList());
        return this;
    }

    public DynamoQuery<T> limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public DynamoQuery<T> withAdjustThroughput() {
        this.throughputAdjuster = new DynamoThroughputAdjuster(this.client.getRawDynamoClient());
        return this;
    }

    public DynamoQuery<T> withAdjustThroughput(long retryLimitMillisecond) {
        this.throughputAdjuster = new DynamoThroughputAdjuster(this.client.getRawDynamoClient(), retryLimitMillisecond);
        return this;
    }

    public DynamoQuery<T> withLoggingInfo() {
        this.enableLoggingInfo = true;
        return this;
    }

    public List<T> getAsList() {
        QueryResult queryResult;
        QueryRequest queryRequest = this.makeQueryRequest(true);
        this.lastQueryResult = queryResult = this.innerExecuteQuery(queryRequest);
        return this.client.toRecords(this.table, queryResult.getItems());
    }

    public List<T> getAsListDesc() {
        QueryResult queryResult;
        QueryRequest queryRequest = this.makeQueryRequest(false);
        this.lastQueryResult = queryResult = this.innerExecuteQuery(queryRequest);
        return this.client.toRecords(this.table, queryResult.getItems());
    }

    public boolean isMoreRecords() {
        return this.lastQueryResult != null && this.lastQueryResult.getLastEvaluatedKey() != null;
    }

    public Integer getCount() {
        QueryResult queryResult = this.client.rawQuery(this.makeQueryRequest(true).withSelect(Select.COUNT));
        return queryResult.getCount();
    }

    private QueryRequest makeQueryRequest(boolean scanIndexForward) {
        String keyConditionExpression = this.makeKeyConditionExpression();
        String filterExpression = this.makeFilterExpression();
        Map<String, String> expressionAttributeNames = this.makeExpressionAttributeNames();
        Map<String, AttributeValue> expressionAttributeValues = this.makeExpressionAttributeValues();
        String projectionExpression = this.makeProjectionExpression();
        Select select = projectionExpression != null ? Select.SPECIFIC_ATTRIBUTES : Select.ALL_ATTRIBUTES;
        ReturnConsumedCapacity returnConsumedCapacity = ReturnConsumedCapacity.TOTAL;
        String realTableName = this.client.getRealTableName(this.table);
        if (log.isDebugEnabled()) {
            log.debug("new QueryRequest().\nrealTableName = " + realTableName + "\nkeyConditionExpression = " + keyConditionExpression + "\nfilterExpression = " + filterExpression + "\nexpressionAttributeNames = " + expressionAttributeNames + "\nexpressionAttributeValues = " + expressionAttributeValues + "\nprojectionExpression = " + projectionExpression);
        }
        return new QueryRequest().withTableName(realTableName).withIndexName(this.getIndexName()).withKeyConditionExpression(keyConditionExpression).withFilterExpression(filterExpression).withExpressionAttributeNames(expressionAttributeNames).withExpressionAttributeValues(expressionAttributeValues).withSelect(select).withProjectionExpression(projectionExpression).withReturnConsumedCapacity(returnConsumedCapacity).withLimit(this.limit).withExclusiveStartKey(this.lastQueryResult != null ? this.lastQueryResult.getLastEvaluatedKey() : null).withScanIndexForward(Boolean.valueOf(scanIndexForward));
    }

    private String makeKeyConditionExpression() {
        StringBuilder sb = new StringBuilder();
        int idx = 1;
        for (DynamoQueryValue keyValue : this.keyValues) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            if (keyValue.getValue() instanceof DynamoBaseAction.RangeValue) {
                sb.append(KNAME + idx + " BETWEEN :kvalue" + idx + " AND :kvalue" + (idx + 1));
                ++idx;
            } else {
                sb.append(KNAME + idx + " = :kvalue" + idx);
            }
            ++idx;
        }
        return sb.toString();
    }

    private Map<String, String> makeExpressionAttributeNames() {
        HashMap<String, String> results = new HashMap<String, String>();
        int idx = 1;
        for (DynamoQueryValue keyValue : this.keyValues) {
            results.put(KNAME + idx, keyValue.getAttributeDefinition().getDynamoAttrName());
            if (++idx <= this.keyValues.size()) continue;
            break;
        }
        idx = 1;
        for (DynamoCondExpression expression : this.filterValues) {
            expression.appendNames(Arrays.asList(idx), results);
            ++idx;
        }
        return results;
    }

    private Map<String, AttributeValue> makeExpressionAttributeValues() {
        HashMap<String, AttributeValue> results = new HashMap<String, AttributeValue>();
        int idx = 1;
        for (DynamoQueryValue keyValue : this.keyValues) {
            Object value = keyValue.getValue();
            if (value instanceof DynamoBaseAction.RangeValue) {
                Object subKeyValue = ((DynamoBaseAction.RangeValue)value).from;
                this.appendKeyValue(results, keyValue.getAttributeDefinition().getMappingType(), idx, subKeyValue);
                subKeyValue = ((DynamoBaseAction.RangeValue)value).to;
                this.appendKeyValue(results, keyValue.getAttributeDefinition().getMappingType(), ++idx, subKeyValue);
            } else {
                this.appendKeyValue(results, keyValue.getAttributeDefinition().getMappingType(), idx, value);
            }
            ++idx;
        }
        idx = 1;
        for (DynamoCondExpression expression : this.filterValues) {
            Object filterValue = expression.getTargetValue();
            DynamoMappingAttributeType mappingType = expression.getMappingType();
            this.appendFilterValue(results, expression, Arrays.asList(idx));
            ++idx;
        }
        return results;
    }

    private QueryResult innerExecuteQuery(QueryRequest queryRequest) {
        if (this.enableLoggingInfo) {
            log.info(queryRequest.toString());
        }
        QueryResult queryResult = this.throughputAdjuster != null ? this.client.rawQueryExponentialBackoff(queryRequest, this.throughputAdjuster) : this.client.rawQuery(queryRequest);
        return queryResult;
    }
}

